/* ---------------------------------------------------------------
 File:                           ThreadDialog.java
 Package:                        FLAP
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti and Magda & Octavian Procopiuc
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package flap;


import java.awt.*;


public class ThreadDialog extends Dialog {

	static final long serialVersionUID = 1L;
	static String NOT_YET = "(notyet)";
  
    String		thePushedButton = NOT_YET;
    // the thread which calls setVisible(true) for this dialog.
    DialogThread		dialogThread = null;

    /**
     * Creates a modal dialog to be shown from within a new thread.
     */ 
    public ThreadDialog(Frame parent, String title) {
        this(parent, title, true);
    }

    /**
     * Creates a dialog to be shown from within a new thread.
     * If parameter modal is true, the dialog will be modal.
     */   
    public ThreadDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
    }

    /**
     * @return 	the button pushed by user.
     */
    public String getPushedButton() {
        return thePushedButton;
    }

    /**
     * Sets the thread from which this dialog's setVisible(true) is called.
     */
    public void setDialogThread(Thread dt) {
        thePushedButton = NOT_YET;
        dialogThread = (DialogThread) dt;
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof Button) {
            thePushedButton = (String) arg;
            setVisible(false);
            if (dialogThread != null) {
                dialogThread.resume();
            } 
        }
        return super.action(e, arg);
    }	// end of method action.

    public boolean handleEvent(Event e) {
        if (e.id == Event.WINDOW_DESTROY) {
            setVisible(false);
            if (dialogThread != null) {
                dialogThread.resume();
            }
        }
        return super.handleEvent(e);
    }

}	// end of class TextInDialog.

