/* ---------------------------------------------------------------
 File:                           Machine.java
 Package:                        FLAP
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Yana Ong, Bharath Oruganti and Magda & Octavian Procopiuc
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package flap;


import java.util.*;


/**
 * This class implements the concept of a machine
 * in the sense used in the automata theory.
 */

abstract public class Machine {

    /**
     * Types of messages displayed while doing a step or fast run
     */
  
    final static int NO_FINAL_STATE_MSG = 0;
    final static int NO_MORE_CONFIGS_MSG = 1;
    final static int MAXNCONFIGS_MSG = 2;
    final static int MAXCOUNT_MSG = 3;
    final static int ACCEPTED_MSG = 4;
    final static int NO_MESSAGE = 5;

    /**
     * Type of this machine 
     */
    public int		type;

    /**
     * Number of configurations generated thus far 
     * (i.e. size of current configuration tree)
     */  
    int 		nConfigs = 0;

    /**
     * Number of configurations generated in the current expand step
     * (i.e. number of leaves in current configuration tree) 
     */
    int		nCurrentConfigs;

    /**
     * Maximum number of configurations the program should generate.
     * Can be interactively modified up to capacity. 
     */
    public int		maxNConfigs = 100;

    /**
     * Capacity of the machine (biggest acceptable value for maxNConfigs).
     */
    public static int	capacity = Params._ma_capacity; 

    /**
     * acceptInput is true if input accepted by machine
     */  
    protected boolean 	acceptInput;

    /**
     * Corresponding desktop (screen image) of the machine
     */ 
    public Desktop	d;

    /**
     * Input string
     */ 
    public String	input = "";

    /**
     * Configurations generated by current expand step
     */
    Vector	currentConfigs;
    Vector        temp;

    /**
     * Creates machine corresponding to its desktop image.
     */
    public Machine(Desktop d) {
        this.d = d;
        currentConfigs = new Vector();
    }

    /**
     * Checks if machine is valid (i.e. has initial state).
     * Will be rewritten in TM1 and TM2, to also check if transition 
     * labels are valid.
     * @return	Message string (null if machine is OK).
     */
    public String checkMachine() {
        if (d.initialState == null) {
            return "The machine has no initial state";
        } else {
            return null;
        }
    }

}	// end of class Machine.
