/* ---------------------------------------------------------------
 File:                           HelpDialog.java
 Package:                        FLAP
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti and Magda & Octavian Procopiuc
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package flap;


import java.awt.*;
import java.util.*;


/**
 * This is the dialog that appears when the user 
 * chooses one of the items in the Help menu.
 * All the text is displayed in a TextArea,
 * which has its own scroll bars.
 */
public class HelpDialog extends Dialog {

	static final long serialVersionUID = 1L;
    final static int	OVERVIEW = 0;
    final static int	STATE = 5;
    final static int	TRANSITION = 15;
    final static int	UPPERWINDOW = 20;
    final static int	TRACEWINDOW = 25;
    final static int	MENUBAR = 30;

    protected String[]	allText = new String[40];
    protected String	text = "nothing";	
    protected int		helpOnWhat;
    protected TextArea	textArea;

    public HelpDialog(int helpOnWhat, Frame parent) {
        super(parent, "", true);
        setTitle("FSA: Help");
        this.helpOnWhat = helpOnWhat;
        setAllText();
        text = allText[helpOnWhat];
        setBackground(Params._h_backcolor);
        setLayout(new BorderLayout());
        Panel p = new Panel();
        Button b = new Button("     OK     ");

        p.add(b);
        b.setBackground(Params._bt_backcolor);
        add("South", p);
        p = new Panel();
        p.setLayout(new BorderLayout());
        p.add("Center",
                textArea = new TextArea(Params._h_rows, Params._h_columns));
        textArea.setEditable(false);
        add("Center", p);
        textArea.setFont(Params._h_font);
        textArea.setText(parseText());
    }
    
    public boolean action(Event e, Object arg) {
        if (e.target instanceof Button) {
            setVisible(false);
        }
        return super.action(e, arg);
    }	// end of method action.

    /**
     * This method is supposed to format the text
     * to fit in the window. It's not totally reliable.
     */
    protected String parseText() {
        String	answer = "";
        StringTokenizer	st = new StringTokenizer(text, " \t\n\r", true);
        int		cmax = textArea.getColumns();
        int		c = 0;
        String	buffer = "";

        while (st.hasMoreTokens()) {
            buffer = st.nextToken();

            if (buffer.indexOf("\n") != -1) {
                c = 0;
            } else {
                c += buffer.length();
            }
            if (c >= cmax) {
                c = 0;
                answer += "\n";
            }
            answer += buffer;
        }
        return answer;
    }	// end of method parseText.

    /**
     * Sets the actual text in the allText array.
     */
    protected void setAllText() {
        allText[OVERVIEW] = // for the FSA.
                "\tOverview\n\n"
                + "This application is a graphical tool for the creation and simulation of finite state automaton.\n\n"
                + "The mouse is used to draw the transition graph of the automaton on the canvas. The canvas is the large rectangular region which is initially blank. States are represented as circles, while transitions are labeled arcs connecting two states.\n\n"
                + "The states of an automaton may be moved about on the canvas once they have been created, to make the layout more eye-pleasing. See the HELP on STATES to find out how to do that.\n\n"
                + "  See HELP on TRANSITIONS to find out how to draw and create them.";


        allText[STATE] = allText[STATE + 1] = allText[STATE + 2] = allText[STATE + 3] = "\tHelp on: STATES\n\n"
                + "Rule of thumb: The states are handled with the CENTER MOUSE BUTTON (if you use a three-button mouse) or with SHIFT & LEFT BUTTON\n\n"
                + "To CREATE a state click the center button on a clear area of the canvas.\n\n"
                + "To MOVE a state, drag it holding the center button down.\n\n"
                + "To RELABEL a state, REMOVE a state or make a state INITIAL or FINAL, "
                + "place the cursor within the state, and hold the RIGHT button "
                + "(or CTRL & LEFT button) down while selecting the desired operation "
                + "from the popup menu, then release the button.\n\n";

        allText[TRANSITION] = // for the FSA
                "\tHelp on: TRANSITIONS\n\n"
                + "Rule of thumb: The transitions are handled with the LEFT MOUSE BUTTON.\n\n"
                + "To create a transition press and hold the LEFT button within the origin state, and release it within the destination state.\n\n"
                + "To DELETE a transition, place the cursor within transition label, press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting the desired item in the popup menu, then release the button.\n\n"
                + "To EDIT a transition label, place the cursor within transition label, then press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting 'Rename this transition' in the popup menu. Then edit its contents using the keyboard."
                + " An epsilon transition is created by simply leaving the contents blank. ";

    }	// end of method setAllText().

}	// end of class HelpDialog
