/* ---------------------------------------------------------------
 File:                           DialogThread.java
 Package:                        FSM Analyzer 1.0
 Author:                         Dr. Ratnesh Kumar and Bharath Oruganti
 V1.0 10/02/97.
 Initial Developers:             Magda & Octavian Procopiuc
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Bharath S. Oruganti.
 * Electrical Engineering Department.
 * University of Kentucky.
 * October, 1997.
 *
 * Copyright (c) 1997
 * All rights reserved.
 */

package flap;


import java.awt.*;


public class DialogThread extends Thread {
    Frame env; // the Frame where threadAction() is defined
    int id; // thread id; used to determine what type
    // dialog this thread is created for
    ThreadDialog dg; // the dialog for which the thread is created

    /**
     * Creates a thread with the given id.
     * This thread's run() will call threadAction(id) which is 
     * defined in env.
     */ 
    public DialogThread(Frame env, int id) {
        this(env, id, null);
    }
  
    /**
     * Creates a thread with the given id.
     * This thread's run() will call threadAction(id) which is
     * defined in env.
     */ 
    public DialogThread(Frame env, int id, ThreadDialog dg) {
        this.env = env;
        this.id = id;
        this.dg = dg; 
    }

    public void run() {
        if (env instanceof Environment) {
            ((Environment) env).threadAction(id);
        } else if (env instanceof MainMenu) {
            ((MainMenu) env).threadAction(id);
        } 
    }

}
