#include "converter.h"
#include "fsm.h"
/*=======================================================================
Function: BadStates()
Comments: This function returns the number of bad states (states which
	  are marked by "@$" in a fsm.
Input: 	  This takes in the address of the fsm.
==========================================================================*/
int BadStates(FSM *fsm1)
{
	ST_LIST *curr;
	int bad_states=0;

	if(!fsm1)
		prog_abort("BadStates:Invalid argument");

	curr = fsm1->states;
	while(curr) {
		if(strstr(curr->name, "@$")!=NULL || strstr(curr->name, "dump")!=NULL) {
			bad_states++;
		}
		curr = curr -> next;
	}
	return(bad_states);
}	
