#include "fsm.h"
#include "converter.h"

/*************************************************************************
Function: SafetyCheck().
Purpose:  This function makes a safety check on the system, to ensure that
	  no transitions lead to the dump state, as this means that the
	  transitions are unsafe in that it violates safety constraints.
	  This safety check is an initialization. None of the states are
	  deleted as of yet.	
**************************************************************************/
int SafetyCheck(FSM *fsm_pr)
{
	int no_of_states, no_of_trans;
	int flag = MAX_LENGTH; /* arbit value */
	ST_LIST *cur_state;
	TR_LIST *cur_tran;
	FILE *fp;

	if(!fsm_pr)
		prog_abort("SafetyCheck: Null pointer arg for FSM *");

	fp = fopen("tmp", "w+");
	no_of_states = get_NStates(fsm_pr);

	/* Initialize state and trans pointers */
	cur_state = fsm_pr->states; /* points to the initial state */
	cur_tran = fsm_pr->states->trans;
	while(cur_state) { /* repeat until all states are covered */
		/* If the state has a second co-ordinate of dump
		state, then mark that state "bad" and tag it with
		the characters "@$", which indicates bad states */
		if(strstr(cur_state->name, "dump")!=NULL) {
			flag = FALSE;
			MarkBadState(fsm_pr, cur_state, cur_tran);
		}
		cur_state = cur_state->next;
	}
	fsm_print(fp, fsm_pr);
	fflush(fp);
	fclose(fp);
	fp = fopen("tmp", "r");
	fsm_read(fp, fsm_pr);
	fclose(fp);
	unlink("tmp");  
	if(flag == MAX_LENGTH)
                return(TRUE);
	else if(flag == FALSE)
		return(FALSE);

} 
