#include "fsm.h"
#include "converter.h"
/*==========================================================================
Function: MarkBadState();
Comments: This function marks the appropriate state as bad, and also goes 
	  and marks this same state which appear in the next_state column
	  too. This is vital so that subsequent iterations can mark states
	  as bad recursilvely, if any transitions lead to this newly marked
	  bad state.
Input:
===========================================================================*/
void MarkBadState(FSM *fsm_mark, ST_LIST *curr_state)
{
	ST_LIST *temp_pr;
	TR_LIST *temp_trans;
	char state_name[MAX_LENGTH];

	if(!fsm_mark)
		prog_abort("MarkBadState: Null pointer passed as arg for FSM*");
	if(!curr_state)
		prog_abort("MarkBadState: Invalid ST_LIST* ");

	strcpy(state_name, curr_state->name);
	/* Mark the state bad if not already*/
	if(strstr(curr_state->name, "@$") ==NULL)
		strcat(curr_state->name, "@$");

	/* Now locate the above state at all the places in the next_state
	column so that these can be marked bad.   as any transition which
	leads to this state is also bad */

	temp_pr = fsm_mark->states;
	temp_trans = temp_pr->trans;
	while(temp_pr) {
	  while(temp_trans) {
		if(strcmp(state_name, temp_trans->next_state->name)==0 && 
		strstr(temp_trans->next_state->name, "@$")==NULL) {
			strcat(temp_trans->next_state->name, "@$");
		} /* if ends */
		temp_trans=temp_trans->next;
	  } /* while temp_trans ends */
	  temp_pr = temp_pr->next;
	} /* while temp_pr ends */

}	/* EOF */
