/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.ContMaskTableWindow;
import flap.Machine;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import mainAnalyzer.DoFileDialog;

public class InputFileFrame
extends JFrame {
    static final long serialVersionUID = 1L;
    Frame parentFrame = null;
    String fileName = null;
    TextField inputFile = new TextField("", 50);
    Button browseButton = new Button("Browse");
    Button okButton = new Button("OK");
    Button cancelButton = new Button("Cancel");
    TextField supervCountField;
    Machine machine = null;
    int noOfSuperv = 1;
    boolean ReadFile = false;

    public InputFileFrame(Frame frame) {
        this.parentFrame = frame;
        this.machine = null;
        this.initializeFrame(null, false);
    }

    public InputFileFrame(Frame frame, String string, Machine machine) {
        this.parentFrame = frame;
        this.fileName = string;
        this.machine = machine;
        this.initializeFrame(string, false);
    }

    public InputFileFrame(Frame frame, String string) {
        this.parentFrame = frame;
        this.fileName = string.substring(0, string.lastIndexOf(95));
        this.initializeFrame(string, true);
    }

    private void initializeFrame(String string, boolean bl) {
        Container container;
        Container container2;
        this.ReadFile = bl;
        if (string == null) {
            this.getContentPane().setLayout(new BorderLayout(3, 1));
            container2 = new Panel();
            container = new JLabel("Please specify the plant filename to which this table belongs :");
            container2.add(container);
            container2.add(this.inputFile);
            container2.add(this.browseButton);
            this.browseButton.addActionListener(new ButtonListener());
            this.getContentPane().add("North", container2);
        } else {
            this.getContentPane().setLayout(new BorderLayout(2, 1));
        }
        if (!this.ReadFile) {
            container2 = new Panel();
            container2.add(new JLabel("Number of Supervisors :"));
            this.supervCountField = new TextField("1", 2);
            this.supervCountField.addTextListener(new TextFieldListener());
            container2.add(this.supervCountField);
            this.getContentPane().add("West", container2);
            container = new Panel();
            container.add(this.okButton);
            container.add(this.cancelButton);
            this.getContentPane().add("South", container);
            this.okButton.addActionListener(new ButtonListener());
            this.cancelButton.addActionListener(new ButtonListener());
            this.setLocation(this.parentFrame.getX() + 10, this.parentFrame.getY() + 10);
            this.setDefaultCloseOperation(2);
            this.pack();
            super.enableEvents(72L);
            this.parentFrame.setEnabled(false);
            this.setVisible(true);
        } else {
            container2 = new ContMaskTableWindow(this.parentFrame, this.fileName);
        }
    }

    class TextFieldListener
    implements TextListener {
        TextFieldListener() {
        }

        public void textValueChanged(TextEvent textEvent) {
            try {
                InputFileFrame.this.noOfSuperv = Integer.parseInt(InputFileFrame.this.supervCountField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(InputFileFrame.this.parentFrame, "Please input \"Number of Supervisors\" in proper format (Integer format).", "Input Error!", 0);
                return;
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Browse")) {
                DoFileDialog doFileDialog = new DoFileDialog(InputFileFrame.this, "Please select a file");
                InputFileFrame.this.inputFile.setText(doFileDialog.getPath());
            } else if (string.equals("OK")) {
                InputFileFrame.this.dispose();
                InputFileFrame.this.parentFrame.setEnabled(true);
                if (InputFileFrame.this.fileName == null) {
                    InputFileFrame.this.fileName = InputFileFrame.this.inputFile.getText();
                }
                if (InputFileFrame.this.fileName.equals("")) {
                    JOptionPane.showMessageDialog(InputFileFrame.this.parentFrame, "No plant file is specified", "No Input Provided!", 0);
                } else {
                    ContMaskTableWindow contMaskTableWindow = new ContMaskTableWindow(InputFileFrame.this.parentFrame, InputFileFrame.this.fileName, InputFileFrame.this.noOfSuperv, InputFileFrame.this.machine);
                    contMaskTableWindow.setLocationRelativeTo(InputFileFrame.this.parentFrame);
                }
            } else if (string.equals("Cancel")) {
                InputFileFrame.this.dispose();
                InputFileFrame.this.fileName = null;
                InputFileFrame.this.parentFrame.setEnabled(true);
            }
        }
    }
}

