/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.Params;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.util.StringTokenizer;

public class HelpDialog
extends Dialog {
    static final long serialVersionUID = 1L;
    static final int OVERVIEW = 0;
    static final int STATE = 5;
    static final int TRANSITION = 15;
    static final int UPPERWINDOW = 20;
    static final int TRACEWINDOW = 25;
    static final int MENUBAR = 30;
    protected String[] allText = new String[40];
    protected String text = "nothing";
    protected int helpOnWhat;
    protected TextArea textArea;

    public HelpDialog(int n, Frame frame) {
        super(frame, "", true);
        this.setTitle("FSA: Help");
        this.helpOnWhat = n;
        this.setAllText();
        this.text = this.allText[n];
        this.setBackground(Params._h_backcolor);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Button button = new Button("     OK     ");
        panel.add(button);
        button.setBackground(Params._bt_backcolor);
        this.add("South", panel);
        panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.textArea = new TextArea(Params._h_rows, Params._h_columns);
        panel.add("Center", this.textArea);
        this.textArea.setEditable(false);
        this.add("Center", panel);
        this.textArea.setFont(Params._h_font);
        this.textArea.setText(this.parseText());
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            this.setVisible(false);
        }
        return super.action(event, object);
    }

    protected String parseText() {
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, " \t\n\r", true);
        int n = this.textArea.getColumns();
        int n2 = 0;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            n2 = string2.indexOf("\n") != -1 ? 0 : (n2 += string2.length());
            if (n2 >= n) {
                n2 = 0;
                string = string + "\n";
            }
            string = string + string2;
        }
        return string;
    }

    protected void setAllText() {
        this.allText[0] = "\tOverview\n\nThis application is a graphical tool for the creation and simulation of finite state automaton.\n\nThe mouse is used to draw the transition graph of the automaton on the canvas. The canvas is the large rectangular region which is initially blank. States are represented as circles, while transitions are labeled arcs connecting two states.\n\nThe states of an automaton may be moved about on the canvas once they have been created, to make the layout more eye-pleasing. See the HELP on STATES to find out how to do that.\n\n  See HELP on TRANSITIONS to find out how to draw and create them.";
        this.allText[8] = "\tHelp on: STATES\n\nRule of thumb: The states are handled with the CENTER MOUSE BUTTON (if you use a three-button mouse) or with SHIFT & LEFT BUTTON\n\nTo CREATE a state click the center button on a clear area of the canvas.\n\nTo MOVE a state, drag it holding the center button down.\n\nTo RELABEL a state, REMOVE a state or make a state INITIAL or FINAL, place the cursor within the state, and hold the RIGHT button (or CTRL & LEFT button) down while selecting the desired operation from the popup menu, then release the button.\n\n";
        this.allText[7] = "\tHelp on: STATES\n\nRule of thumb: The states are handled with the CENTER MOUSE BUTTON (if you use a three-button mouse) or with SHIFT & LEFT BUTTON\n\nTo CREATE a state click the center button on a clear area of the canvas.\n\nTo MOVE a state, drag it holding the center button down.\n\nTo RELABEL a state, REMOVE a state or make a state INITIAL or FINAL, place the cursor within the state, and hold the RIGHT button (or CTRL & LEFT button) down while selecting the desired operation from the popup menu, then release the button.\n\n";
        this.allText[6] = "\tHelp on: STATES\n\nRule of thumb: The states are handled with the CENTER MOUSE BUTTON (if you use a three-button mouse) or with SHIFT & LEFT BUTTON\n\nTo CREATE a state click the center button on a clear area of the canvas.\n\nTo MOVE a state, drag it holding the center button down.\n\nTo RELABEL a state, REMOVE a state or make a state INITIAL or FINAL, place the cursor within the state, and hold the RIGHT button (or CTRL & LEFT button) down while selecting the desired operation from the popup menu, then release the button.\n\n";
        this.allText[5] = "\tHelp on: STATES\n\nRule of thumb: The states are handled with the CENTER MOUSE BUTTON (if you use a three-button mouse) or with SHIFT & LEFT BUTTON\n\nTo CREATE a state click the center button on a clear area of the canvas.\n\nTo MOVE a state, drag it holding the center button down.\n\nTo RELABEL a state, REMOVE a state or make a state INITIAL or FINAL, place the cursor within the state, and hold the RIGHT button (or CTRL & LEFT button) down while selecting the desired operation from the popup menu, then release the button.\n\n";
        this.allText[15] = "\tHelp on: TRANSITIONS\n\nRule of thumb: The transitions are handled with the LEFT MOUSE BUTTON.\n\nTo create a transition press and hold the LEFT button within the origin state, and release it within the destination state.\n\nTo DELETE a transition, place the cursor within transition label, press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting the desired item in the popup menu, then release the button.\n\nTo EDIT a transition label, place the cursor within transition label, then press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting 'Rename this transition' in the popup menu. Then edit its contents using the keyboard. An epsilon transition is created by simply leaving the contents blank. ";
    }
}

