/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.Params;
import flap.Popup;
import flap.State;
import flap.Transition;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Desktop
extends Canvas {
    static final long serialVersionUID = 1L;
    public State initialState = null;
    public Transition selectedTransition;
    public State selectedState;
    public Vector theStates;
    public Vector theTransitions;
    public boolean modified = false;
    public boolean disabled;
    boolean autoRelabel = false;
    int currentId = 0;
    int currenttrId = 0;
    protected int x_offset = 0;
    protected int y_offset = 0;
    protected Color backcolor = Params._d_backcolor;
    protected Popup menu;
    protected boolean menuOn = false;
    protected State firstState = null;
    protected Transition firstTransition = null;
    protected Point drag = null;
    protected int draggingWhat;
    protected String[] sublabel = new String[6];
    protected int selectedSublabel = 0;
    protected int fieldCounter = 1;
    protected String[] separator = new String[6];
    protected String[] ssublabel = new String[6];
    protected int sselectedSublabel = 0;
    protected int sfieldCounter = 1;
    protected String[] sseparator = new String[6];
    static final int DG_NOTHING = 0;
    static final int DG_STATE = 1;
    static final int DG_TRANS = 2;
    static final int DG_LABEL = 3;
    static final String EMPTY_STR = "-----";
    private Image offscr = null;
    private Graphics offg = null;
    private int count = 0;
    private int off = 0;
    private int offr = 4;
    private int voff1 = 4;
    private int voff2 = 2;
    private int hoff1 = 2;
    private int hoff2 = 3;
    private int arrow_length = 12;
    private int arrow_width = 10;
    private double df = 1.5;

    public Desktop() {
        this.theStates = new Vector(10, 1);
        this.theTransitions = new Vector(30, 1);
        this.menu = new Popup(this);
        this.separator[this.fieldCounter - 1] = "";
    }

    public boolean keyDown(Event event, int n) {
        this.requestFocus();
        if (this.selectedTransition == null && this.selectedState == null) {
            return super.keyDown(event, n);
        }
        if (this.selectedTransition != null && this.selectedTransition.rename) {
            if (n >= 32 && n <= 126) {
                String string = this.selectedTransition.label + new Character((char)n);
                this.selectedTransition.label = null;
                this.selectedTransition.label = string;
                this.modified = true;
            } else if (n == 8 || n == 127) {
                int n2 = this.selectedTransition.label.length();
                if (n2 > 1) {
                    String string = this.selectedTransition.label.substring(0, n2 - 1);
                    this.selectedTransition.label = null;
                    this.selectedTransition.label = string;
                    this.modified = true;
                } else if (n2 == 1) {
                    this.selectedTransition.label = "";
                    this.modified = true;
                }
            }
        } else if (this.selectedState != null && this.selectedState.rename) {
            if (n >= 32 && n <= 126) {
                String string = this.selectedState.label + new Character((char)n);
                this.selectedState.label = null;
                this.selectedState.label = string;
                this.modified = true;
            } else if (n == 8 || n == 127) {
                int n3 = this.selectedState.label.length();
                if (n3 > 1) {
                    String string = this.selectedState.label.substring(0, n3 - 1);
                    this.selectedState.label = null;
                    this.selectedState.label = string;
                    this.modified = true;
                } else if (n3 == 1) {
                    this.selectedState.label = "";
                    this.modified = true;
                }
            }
        }
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.selectedTransition != null) {
            this.selectedTransition.rename = false;
        }
        if (this.selectedState != null) {
            this.selectedState.rename = false;
        }
        this.requestFocus();
        switch (event.modifiers) {
            case 1: 
            case 8: {
                State state = this.isInState(n, n2);
                if (state != null) {
                    this.draggingWhat = 1;
                    this.firstState = state;
                    this.x_offset = n - state.p.x;
                    this.y_offset = n2 - state.p.y;
                    this.modified = true;
                    break;
                }
                if (this.isGoodLocation(n, n2)) {
                    state = this.addState(n, n2);
                    if (this.theStates.size() == 1) {
                        this.initialState = state;
                    }
                    this.draggingWhat = 1;
                    this.firstState = state;
                    this.x_offset = 0;
                    this.y_offset = 0;
                    this.modified = true;
                    break;
                }
                this.draggingWhat = 0;
                break;
            }
            case 0: {
                Transition transition = this.isInTransition(n, n2);
                if (transition != null) {
                    this.draggingWhat = 3;
                    this.firstTransition = transition;
                    Point point = this.locateLabel(transition);
                    this.x_offset = n - point.x;
                    this.y_offset = n2 - point.y;
                    this.selectedTransition = transition;
                    break;
                }
                State state = this.isInState(n, n2);
                if (state != null) {
                    this.draggingWhat = 2;
                    this.firstState = state;
                    this.drag = new Point(n, n2);
                    break;
                }
                this.draggingWhat = 0;
                break;
            }
            case 2: 
            case 4: {
                this.menuOn = true;
                this.menu.setLocation(n, n2);
                this.menu.invalidateAll();
                Transition transition = this.isInTransition(n, n2);
                if (transition != null) {
                    this.menu.setTransition(transition);
                    break;
                }
                State state = this.isInState(n, n2);
                if (state == null) break;
                this.menu.setState(state);
                break;
            }
        }
        this.repaint();
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.selectedTransition != null) {
            this.selectedTransition.rename = false;
        }
        if (this.selectedState != null) {
            this.selectedState.rename = false;
        }
        switch (event.modifiers) {
            case 1: 
            case 8: {
                if (this.draggingWhat != 1) break;
                this.firstState.setLocation(n - this.x_offset, n2 - this.y_offset);
                break;
            }
            case 0: {
                if (this.draggingWhat == 2) {
                    this.drag.setLocation(n, n2);
                    break;
                }
                if (this.draggingWhat != 3 || this.firstTransition.from != this.firstTransition.to) break;
                this.moveLoop(this.firstTransition, n - this.x_offset, n2 - this.y_offset);
                break;
            }
            case 2: 
            case 4: {
                if (n >= this.menu.p.x && n <= this.menu.p.x + this.menu.width) {
                    int n3 = (int)Math.floor((n2 - this.menu.p.y) / this.menu.height);
                    if (n2 >= this.menu.p.y && n3 < this.menu.itemsCounter) {
                        this.menu.hasFocus = n3;
                        break;
                    }
                    this.menu.hasFocus = -1;
                    break;
                }
                this.menu.hasFocus = -1;
            }
        }
        this.repaint();
        return super.mouseDrag(event, n, n2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        switch (event.modifiers) {
            case 1: 
            case 8: {
                if (this.draggingWhat != 1) break;
                this.draggingWhat = 0;
                this.firstState.setLocation(n - this.x_offset, n2 - this.y_offset);
                this.x_offset = 0;
                this.y_offset = 0;
                this.firstState = null;
                break;
            }
            case 0: {
                if (this.draggingWhat == 3) {
                    this.draggingWhat = 0;
                    if (this.firstTransition.from == this.firstTransition.to) {
                        this.moveLoop(this.firstTransition, n - this.x_offset, n2 - this.y_offset);
                    }
                    this.x_offset = 0;
                    this.y_offset = 0;
                    this.firstTransition = null;
                    break;
                }
                if (this.draggingWhat != 2) break;
                State state = this.isInState(n, n2);
                if (state != null) {
                    Transition transition;
                    this.selectedTransition = transition = this.addTransition(this.firstState, state);
                    if (this.firstState == state) {
                        Transition transition2 = this.sameStatesTransition(transition);
                        transition.distance = transition2 == null ? Params._t_ltheight : transition2.distance;
                    }
                    this.modified = true;
                }
                this.drag = null;
                this.firstState = null;
                this.draggingWhat = 0;
            }
        }
        if (this.menuOn) {
            this.menuOn = false;
            if (this.menu.takeAction()) {
                this.modified = true;
            }
        }
        this.repaint();
        return super.mouseUp(event, n, n2);
    }

    private void moveLoop(Transition transition, int n, int n2) {
        boolean bl = false;
        Transition transition2 = null;
        int n3 = this.theTransitions.size();
        int n4 = 0;
        while (!bl && n4 < n3) {
            transition2 = (Transition)this.theTransitions.elementAt(n4);
            if (transition2 == transition) {
                bl = true;
                continue;
            }
            ++n4;
        }
        if (transition2 == transition) {
            Enumeration enumeration = this.theTransitions.elements();
            while (enumeration.hasMoreElements()) {
                transition2 = (Transition)enumeration.nextElement();
                if (transition2.from != this.firstTransition.from || transition2.to != this.firstTransition.to) continue;
                transition2.setLocation(n, n2);
            }
        }
    }

    private Transition sameStatesTransition(Transition transition) {
        boolean bl = false;
        Transition transition2 = null;
        int n = this.theTransitions.size();
        int n2 = 0;
        while (!bl && n2 < n) {
            transition2 = (Transition)this.theTransitions.elementAt(n2);
            if (transition2.from == transition.from && transition2.to == transition.to && transition2 != transition) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl ? transition2 : null;
    }

    void setTransitions(State state, boolean bl) {
        state.transitions.removeAllElements();
        Enumeration enumeration = this.theTransitions.elements();
        while (enumeration.hasMoreElements()) {
            Transition transition = (Transition)enumeration.nextElement();
            if (transition.from != state) continue;
            if (bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(transition.label, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken().trim();
                    state.transitions.addElement(new Transition(transition.id, state, transition.to, string));
                }
                continue;
            }
            state.transitions.addElement(transition);
        }
        state.transitionCount = state.transitions.size();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.backcolor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Params._d_forecolor);
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        Enumeration enumeration = this.theTransitions.elements();
        while (enumeration.hasMoreElements()) {
            this.paintLine(graphics, (Transition)enumeration.nextElement());
        }
        if (this.drag != null) {
            graphics.setColor(Params._t_selectedcolor);
            graphics.drawLine(this.firstState.p.x, this.firstState.p.y, this.drag.x, this.drag.y);
        }
        enumeration = this.theStates.elements();
        while (enumeration.hasMoreElements()) {
            this.paintState(graphics, (State)enumeration.nextElement());
        }
        if (this.initialState != null) {
            this.paintInitial(graphics, this.initialState);
        }
        graphics.setFont(Params._t_font);
        enumeration = this.theTransitions.elements();
        while (enumeration.hasMoreElements()) {
            this.paintTransition(graphics, (Transition)enumeration.nextElement());
        }
        if (this.selectedTransition != null && this.theTransitions.indexOf(this.selectedTransition) != -1) {
            this.paintTransition(graphics, this.selectedTransition);
        }
        if (this.menuOn) {
            this.paintPopup(graphics);
        }
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscr == null) {
            this.offscr = this.createImage(dimension.width, dimension.height);
            this.offg = this.offscr.getGraphics();
        }
        if (this.offscr.getWidth(this) != dimension.width || this.offscr.getHeight(this) != dimension.height) {
            this.offscr = this.createImage(dimension.width, dimension.height);
            this.offg = this.offscr.getGraphics();
        }
        if (this.offg == null) {
            this.paint(graphics);
        } else {
            this.paint(this.offg);
            graphics.drawImage(this.offscr, 0, 0, null);
        }
    }

    private void paintLine(Graphics graphics, Transition transition) {
        int n = 8;
        Color color = transition == this.selectedTransition ? Params._t_selectedcolor : (transition.st == 0 ? Params._t_normalcolor : Params._t_focusedcolor);
        graphics.setColor(color);
        if (transition.from == transition.to) {
            graphics.drawOval(transition.from.p.x - n, transition.from.p.y - transition.distance, 2 * n, transition.distance);
        } else {
            graphics.drawLine(transition.from.p.x, transition.from.p.y, transition.to.p.x, transition.to.p.y);
        }
    }

    private void computeArrow(Transition transition, Point point, int[] nArray, int[] nArray2) {
        int n = transition.from.p.x;
        int n2 = transition.from.p.y;
        int n3 = transition.to.p.x;
        int n4 = transition.to.p.y;
        if (Math.abs(n3 - n) > Math.abs(n4 - n2)) {
            this.off = this.hoff1 + this.arrow_length + 2;
            if (n3 > n) {
                nArray[0] = nArray[1] = point.x + this.hoff1;
                nArray[2] = point.x + this.hoff1 + this.arrow_length;
                nArray2[0] = point.y + this.voff1;
                nArray2[1] = point.y + this.voff1 + this.arrow_width;
                nArray2[2] = point.y + this.voff1 + this.arrow_width / 2;
            } else {
                nArray[0] = nArray[1] = point.x + this.hoff1 + this.arrow_length;
                nArray[2] = point.x + this.hoff1;
                nArray2[0] = point.y + this.voff1;
                nArray2[1] = point.y + this.voff1 + this.arrow_width;
                nArray2[2] = point.y + this.voff1 + this.arrow_width / 2;
            }
        } else {
            this.off = this.hoff2 + this.arrow_width + 2;
            if (n4 > n2) {
                nArray[0] = point.x + this.hoff2;
                nArray[1] = point.x + this.hoff2 + this.arrow_width;
                nArray[2] = point.x + this.hoff2 + this.arrow_width / 2;
                nArray2[0] = nArray2[1] = point.y + this.voff2;
                nArray2[2] = point.y + this.voff2 + this.arrow_length;
            } else {
                nArray[0] = point.x + this.hoff2;
                nArray[1] = point.x + this.hoff2 + this.arrow_width;
                nArray[2] = point.x + this.hoff2 + this.arrow_width / 2;
                nArray2[0] = nArray2[1] = point.y + this.voff2 + this.arrow_length;
                nArray2[2] = point.y + this.voff2;
            }
        }
    }

    private void paintTransition(Graphics graphics, Transition transition) {
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = n = transition == this.selectedTransition ? fontMetrics.stringWidth("_") : 0;
        Color color = transition == this.selectedTransition ? Params._t_selectedcolor : (transition.st == 0 ? Params._t_normalcolor : Params._t_focusedcolor);
        Point point = this.locateLabel(transition);
        int n3 = fontMetrics.getAscent();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        this.computeArrow(transition, point, nArray, nArray2);
        graphics.setColor(Params._t_interiorcolor);
        graphics.fillRect(point.x, point.y, fontMetrics.stringWidth(transition.label) + this.off + this.offr + n, Params._t_height);
        graphics.setColor(Params._t_makecontcolor);
        graphics.drawRect(point.x, point.y, fontMetrics.stringWidth(transition.label) + this.off + this.offr + n, Params._t_height);
        if (transition.from == transition.to) {
            graphics.fillOval(point.x + this.hoff1, point.y + this.voff1, this.arrow_width, this.arrow_width);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        int n4 = point.y - 2 + (Params._t_height + n3) / 2;
        if (transition != this.selectedTransition) {
            graphics.drawString(transition.label, point.x + this.off, n4);
        } else {
            int n5 = point.x + this.off;
            graphics.setColor(Params._t_selectedcolor);
            graphics.drawString(transition.label, n5, n4);
            graphics.setColor(Params._t_normalcolor);
        }
    }

    private void paintState(Graphics graphics, State state) {
        int n = 2 * Params._s_radius;
        int n2 = 2;
        Color color = state.ss == 0 ? Params._s_normalcolor : Params._s_focusedcolor;
        graphics.setColor(color);
        graphics.fillOval(state.p.x - Params._s_radius, state.p.y - Params._s_radius, n, n);
        graphics.setColor(Params._s_forecolor);
        graphics.drawOval(state.p.x - Params._s_radius, state.p.y - Params._s_radius, n, n);
        graphics.setFont(Params._s_font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = "q" + Integer.toString(state.id);
        if (state.label == "" && !state.rename) {
            state.label = string;
        }
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getAscent();
        if (this.selectedState != null) {
            String string2 = state.label;
            graphics.drawString(string2, state.p.x - n3 / 2, state.p.y + n4 / 2);
            string2 = "";
        } else {
            graphics.drawString(state.label, state.p.x - n3 / 4, state.p.y + n4 / 2);
        }
        if (state.isFinal) {
            graphics.drawOval(state.p.x - Params._s_radius - n2, state.p.y - Params._s_radius - n2, n + 2 * n2, n + 2 * n2);
        }
    }

    private void paintInitial(Graphics graphics, State state) {
        int n = Params._s_radius;
        int[] nArray = new int[]{state.p.x - n, state.p.x - 2 * n, state.p.x - 2 * n, state.p.x - n};
        int[] nArray2 = new int[]{state.p.y, state.p.y - n, state.p.y + n, state.p.y};
        graphics.setColor(Params._s_forecolor);
        graphics.drawPolygon(nArray, nArray2, 4);
    }

    private void paintPopup(Graphics graphics) {
        Point point;
        graphics.setFont(Params._p_font);
        graphics.setColor(Params._p_backcolor);
        graphics.fill3DRect(this.menu.p.x, this.menu.p.y - 5, this.menu.width, this.menu.height * this.menu.itemsCounter + 10, true);
        if (this.menu.hasFocus >= 0 && this.menu.isValid[this.menu.hasFocus]) {
            graphics.setColor(Params._p_focusedcolor);
            graphics.fillRect(this.menu.p.x + 5, this.menu.p.y + 1 + this.menu.hasFocus * this.menu.height, this.menu.width - 10, this.menu.height - 2);
        }
        graphics.setColor(Params._p_foreStateColor);
        int n = 0;
        for (n = 0; n < this.menu.stateItemsCounter; ++n) {
            if (!this.menu.isValid[n]) continue;
            point = this.menu.writeHere(n);
            graphics.drawString(this.menu.theItems[n], point.x, point.y);
        }
        graphics.setColor(Params._p_foreTransColor);
        while (n < this.menu.itemsCounter) {
            if (this.menu.isValid[n]) {
                point = this.menu.writeHere(n);
                graphics.drawString(this.menu.theItems[n], point.x, point.y);
            }
            ++n;
        }
        graphics.setColor(Params._p_invalidcolor);
        for (int i = 0; i < this.menu.itemsCounter; ++i) {
            if (this.menu.isValid[i]) continue;
            point = this.menu.writeHere(i);
            graphics.drawString(this.menu.theItems[i], point.x, point.y);
        }
    }

    public State addState(int n, int n2) {
        State state = new State(this.currentId++, false, n, n2);
        this.theStates.addElement(state);
        return state;
    }

    public State isInState(int n, int n2) {
        State state = null;
        boolean bl = false;
        Enumeration enumeration = this.theStates.elements();
        while (enumeration.hasMoreElements() && !bl) {
            state = (State)enumeration.nextElement();
            if (Math.abs(state.p.x - n) >= Params._s_radius || Math.abs(state.p.y - n2) >= Params._s_radius) continue;
            bl = true;
        }
        if (bl) {
            return state;
        }
        return null;
    }

    public Transition addTransition(State state, State state2) {
        String string = "";
        Transition transition = new Transition(this.currenttrId++, state, state2, string);
        this.theTransitions.addElement(transition);
        return transition;
    }

    public void removeTransition(Transition transition) {
        if (this.selectedTransition == transition) {
            this.selectedTransition = null;
        }
        this.theTransitions.removeElement(transition);
    }

    public Point locateLabel(Transition transition) {
        int n;
        int n2;
        int n3 = this.theTransitions.indexOf(transition);
        int n4 = transition.from.p.x;
        int n5 = transition.from.p.y;
        int n6 = transition.to.p.x;
        int n7 = transition.to.p.y;
        this.count = 0;
        for (int i = 0; i < n3; ++i) {
            Transition transition2 = (Transition)this.theTransitions.elementAt(i);
            if (transition2.from != transition.from || transition2.to != transition.to) continue;
            ++this.count;
        }
        if (transition.from == transition.to) {
            n2 = (int)((double)(n5 - transition.distance) + (double)(this.count * Params._t_height) * this.df);
            n2 = Math.min(n2, n5 - Params._t_distance);
            n = n4;
        } else {
            double d = Math.sqrt((n6 - n4) * (n6 - n4) + (n7 - n5) * (n7 - n5));
            double d2 = (double)transition.distance + (double)this.count * ((double)Params._t_height * this.df);
            d2 = Math.min(d2, d / 2.0 - (double)(Params._t_height / 2) + 1.0);
            n = (int)((d2 /= d) * (double)n6 + (1.0 - d2) * (double)n4);
            n2 = (int)(d2 * (double)n7 + (1.0 - d2) * (double)n5);
            if (n4 > n6 && n5 > n7) {
                n += 8;
                n2 += 8;
            }
        }
        return new Point(n, n2);
    }

    public Transition isInTransition(int n, int n2) {
        Transition transition = null;
        boolean bl = false;
        FontMetrics fontMetrics = this.getFontMetrics(Params._t_font);
        Vector vector = new Vector(this.theTransitions.size());
        Enumeration enumeration = this.theTransitions.elements();
        while (enumeration.hasMoreElements()) {
            vector.insertElementAt(enumeration.nextElement(), 0);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements() && !bl) {
            transition = (Transition)enumeration.nextElement();
            Point point = this.locateLabel(transition);
            int n3 = point.x;
            int n4 = point.y;
            if (n - n3 > fontMetrics.stringWidth(transition.label) + this.off + this.offr || n - n3 < 0 || n2 - n4 > Params._t_height || n2 - n4 < 0) continue;
            bl = true;
        }
        if (bl) {
            return transition;
        }
        return null;
    }

    boolean isGoodLocation(int n, int n2) {
        return true;
    }

    public void changeAspect(boolean bl) {
        if (bl) {
            this.selectedTransition = null;
            this.backcolor = Params._d_fadedbackcolor;
        } else {
            this.backcolor = Params._d_backcolor;
            Enumeration enumeration = this.theStates.elements();
            while (enumeration.hasMoreElements()) {
                State state = (State)enumeration.nextElement();
                state.ss = 0;
            }
        }
        this.repaint();
    }

    public void relabel() {
        int n = 0;
        int n2 = 0;
        State state = null;
        Transition transition = null;
        Enumeration enumeration = this.theStates.elements();
        while (enumeration.hasMoreElements()) {
            state = (State)enumeration.nextElement();
            state.id = n++;
        }
        this.currentId = n;
        enumeration = this.theTransitions.elements();
        while (enumeration.hasMoreElements()) {
            transition = (Transition)enumeration.nextElement();
            transition.id = n2++;
        }
        this.currenttrId = n2;
    }

    public void unfocusAll() {
        State state = null;
        Enumeration enumeration = this.theStates.elements();
        while (enumeration.hasMoreElements()) {
            state = (State)enumeration.nextElement();
            state.ss = 0;
        }
    }

    public String toTabular() {
        int n;
        State state;
        int n2 = this.theStates.size() + 1;
        int n3 = this.theTransitions.size() + this.theStates.size();
        String[][] stringArray = new String[n3][n2];
        String[] stringArray2 = new String[n2];
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string = "";
        String string2 = "Final States: ";
        String string3 = "Start state: " + (this.initialState != null ? "q" + this.initialState.id : "");
        if (this.theStates.size() == 0) {
            return " ";
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                stringArray[j][i] = EMPTY_STR;
            }
            nArray[i] = 0;
        }
        Object object = this.theStates.elements();
        while (object.hasMoreElements()) {
            state = (State)object.nextElement();
            if (state.isFinal) {
                string2 = string2 + " q" + state.id;
            }
            stringArray[n5][0] = "q" + state.id + "\t|";
            n6 = 1;
            this.setTransitions(state, false);
            Enumeration enumeration = state.transitions.elements();
            while (enumeration.hasMoreElements()) {
                Transition transition = (Transition)enumeration.nextElement();
                n4 = this.theStates.indexOf(transition.to) + 1;
                if (transition.label.length() > nArray[n4]) {
                    nArray[n4] = transition.label.length();
                }
                int n7 = 0;
                while (!stringArray[n5 + n7][n4].equals(EMPTY_STR)) {
                    stringArray[n5 + ++n7][0] = "\t|";
                }
                stringArray[n5 + n7][n4] = transition.label.trim();
                if (n7 + 1 <= n6) continue;
                n6 = n7 + 1;
            }
            n5 += n6;
        }
        n3 = n5;
        int n8 = 0;
        string = "";
        string = string + string3 + "\n";
        string = string + string2 + "\n";
        string = string + "Transition function: \n";
        string = string + "\n\t ";
        Enumeration enumeration = this.theStates.elements();
        while (enumeration.hasMoreElements()) {
            state = (State)enumeration.nextElement();
            object = "q" + state.id;
            n4 = this.theStates.indexOf(state) + 1;
            stringArray2[n4] = " " + this.toLength((String)object, nArray[n4]) + " ";
            string = string + stringArray2[n4];
            n8 += Math.max(nArray[n4], 3) + 2;
        }
        string = string + "\n";
        string = string + "\t-";
        for (n = 0; n < n8; ++n) {
            string = string + "-";
        }
        string = string + "\n";
        for (n = 0; n < n3; ++n) {
            int n9;
            if (!stringArray[n][0].equals("\t|") && n > 0) {
                string = string + "\t|";
                for (n9 = 0; n9 < n8; ++n9) {
                    string = string + "-";
                }
                string = string + "\n";
            }
            string = string + " " + stringArray[n][0];
            for (n9 = 1; n9 < n2; ++n9) {
                stringArray[n][n9] = " " + this.toLength(stringArray[n][n9], nArray[n9]) + "|";
                string = string + stringArray[n][n9];
            }
            string = string + "\n";
        }
        string = string + "\t-";
        for (n = 0; n < n8; ++n) {
            string = string + "-";
        }
        string = string + "\n";
        return string;
    }

    protected String toLength(String string, int n) {
        int n2;
        String string2 = new String(string);
        int n3 = Math.max(3, n);
        if (string2.equals(EMPTY_STR)) {
            string2 = "-";
        }
        for (int i = n2 = string2.length(); i < n3; ++i) {
            string2 = string2 + " ";
        }
        return string2;
    }

    protected void tokenizeIt(String string) {
        String string2 = "";
        for (int i = 0; i < this.fieldCounter; ++i) {
            string2 = string2 + this.separator[i];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        for (int i = 0; i < this.fieldCounter; ++i) {
            this.sublabel[i] = stringTokenizer.nextToken();
        }
    }
}

