/* ---------------------------------------------------------------
 File:                           InputFrame.java
 Package:                        FSM Analyzer 2.0
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */
 
package mainAnalyzer;


import java.awt.*;


// **************************************
// * This provides a frame for the Applet
// **************************************
public class InputFrame extends Frame {
    
	static final long serialVersionUID = 1L;
	Input teApplet;

    public InputFrame(Input t, String Title, String openWithFile) {
        setTitle(Title);
        teApplet = t;

        teApplet.inAnApplet = false;
        // Call init() method as a browser would
        teApplet.init();
        add("Center", teApplet);
        teApplet.parent = (Frame) this;

        // Open a file if requested
        if (openWithFile != null) {
            teApplet.readFile(openWithFile);
        }

        super.enableEvents(AWTEvent.WINDOW_EVENT_MASK | AWTEvent.KEY_EVENT_MASK);
        pack();
        setVisible(true);
    }

    protected void processEvent(AWTEvent evt) {
        // Forward all events to Applet class
        if (teApplet != null) {
            teApplet.callProcessEvent(evt);
        } else {
            super.processEvent(evt);
        }

    }
}
