/* ---------------------------------------------------------------
 File:                           TextInDialog.java
 Package:                        FLAP
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Bharath Oruganti and Magda & Octavian Procopiuc
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package flap;


import java.awt.*;
import java.util.StringTokenizer;


/**
 * This is a modal Dialog in which some centered text is displayed
 * and a number of buttons are placed at the bottom. When one of these
 * buttons is pressed, the dialog is hidden and the label of the pressed
 * button can be obtained by calling getPushedButton.
 */

public class TextInDialog extends ThreadDialog {

	static final long serialVersionUID = 1L;
    /**
     * Text to be displayed in the dialog window.
     */ 
    protected String	message;

    /**
     * Width of dialog window
     */
    protected int		width = Params._dg_width;

    /**
     * Height of dialog window
     */
    protected int		height = Params._dg_height;

    /**
     * Labels of the buttons in the dialog window.
     */  
    protected String[]	buttons;

    /**
     * Creates a modal dialog containing a text message and some buttons.
     */
    public TextInDialog(String message, String[] buttons, Frame parent, String title) {
        this(message, buttons, parent, title, true);
    }

    /**
     * Creates a dialog containing a text message and some buttons.
     * If parameter modal is true, the dialog is modal. 
     */  
    public TextInDialog(String message, String[] buttons, Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.message = message;
        this.buttons = buttons;
        setFont(Params._dg_font);
        setBackground(Params._dg_backcolor);
        setLayout(new BorderLayout());
        Panel p = new Panel();

        if (buttons != null) {
            Button b = null;

            for (int i = 0; i < buttons.length; i++) {
                b = new Button(buttons[i]);
                b.setBackground(Params._bt_backcolor);
                p.add(b);
            }
        }
        add("South", p);
        setSize(width, height);
    }

    /**
     * Paints the message line by line.
     */ 
    public void paint(Graphics g) {
        String str;
        Dimension d = size();

        g.setColor(Params._dg_backcolor);
        g.fillRect(0, 0, d.width - 1, d.height - 1);
        g.setColor(Params._dg_forecolor);
        int	i = 0;
        StringTokenizer st = new StringTokenizer(message, "\n", false);
        int count = st.countTokens();
        FontMetrics fm = g.getFontMetrics();

        while (st.hasMoreTokens()) {
            str = st.nextToken();
            g.drawString(str, d.width / 2 - fm.stringWidth(str) / 2,
                    d.height / 2 - fm.getHeight() / 2
                    - fm.getHeight() * (count / 2 - i++));
        }
    }

}	// end of class TextInDialog.

