/* ---------------------------------------------------------------
 File:                           State.java
 Package:                        FLAP
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Yana Ong, Bharath Oruganti and Magda & Octavian Procopiuc
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */

package flap;


import java.awt.Point;
import java.util.Vector;


/**
 * This class implements a state of a machine.
 * The painting of a state is done in the Desktop class.
 */

public class State {
    int		id;
    boolean	isFinal;
    Point		p; // the position relative to the desktop
    int		ss; // NORMAL or FOCUSED 
    Vector 	transitions;
    String	label;	
    int		transitionCount; // total number of transitions - Yana
    boolean rename = false; // true if user chooses to rename its label - Yana

    final static int NORMAL = 0;
    final static int FOCUSED = 1;

    /**
     * Constructs a new State with the specified label, isFinal flag,
     * and position.
     */
    public State(int id, boolean isFinal, int x, int y) {
        this.id = id;
        this.isFinal = isFinal;
        ss = State.NORMAL;
        transitions = new Vector(0);
        p = new Point(x, y);
        this.label = "";
        transitionCount = 0;
    }

    /**
     * Construct a new, uninitialized, state.
     * Used when reading a machine from a file.
     */
    public State() {
        this(-1, false, -1, -1);
    }

    void setLocation(int x, int y) {
        p.setLocation(x, y);
    }

    public void SetStateLabel(String str) {
        this.label = null;
        this.label = str;
    }
}
