/* ---------------------------------------------------------------
 File:                           InputFileFrame.java
 Package:                        FLAP
 Author:                         Dr. Ratnesh Kumar and Greg Stamp
 V2.0 10/28/2006
 Initial Developers: Yana Ong
 ---------------------------------------------------------------*/
 
/*
 * Dr. Ratnesh Kumar, Greg Stamp.
 * Department of Electrical and Computer Engineering
 * Iowa State University
 * October, 2006.
 *
 * Copyright (c) 2006
 * All rights reserved.
 */
package flap; 


import java.awt.*; 
import java.awt.event.*;
import javax.swing.*;
import mainAnalyzer.DoFileDialog;


public class InputFileFrame extends JFrame {
    
	static final long serialVersionUID = 1L;
	Frame parentFrame = null;
    String fileName = null;
    TextField inputFile = new TextField("", 50);
    Button browseButton = new Button("Browse");
    Button okButton = new Button("OK");
    Button cancelButton = new Button("Cancel");
    TextField supervCountField;
    Machine machine = null;
    int noOfSuperv = 1;
    boolean ReadFile = false;

    public InputFileFrame(Frame parent) {  
        parentFrame = parent;
        machine = null;
        initializeFrame(null, false); //added 0
    }

    public InputFileFrame(Frame pFrame, String fName, Machine mach) {
        parentFrame = pFrame;
        fileName = fName;
        machine = mach;
        initializeFrame(fName, false); //added 0
    }
    //added
    public InputFileFrame(Frame pFrame, String fName) {
        parentFrame = pFrame;
        //in this instance, should read file to determine number of supervisors!
        //remove _events frome filename because this is added in contmasktablewindow
        fileName = fName.substring(0,fName.lastIndexOf('_'));
        initializeFrame(fName, true); //added 1
    }    
 
    private void initializeFrame(String fName, boolean read_file) {
        ReadFile = read_file; //added, see if reading a file 1 = yes
        if (fName == null) {
            this.getContentPane().setLayout(new BorderLayout(3, 1));
            Panel firstPanel = new Panel();
            JLabel lbl = new JLabel(
                    "Please specify the plant filename to which this table belongs :"); 

            firstPanel.add(lbl);
            firstPanel.add(inputFile);
            firstPanel.add(browseButton);
            browseButton.addActionListener(new ButtonListener());
            this.getContentPane().add("North", firstPanel);
        } else {
            this.getContentPane().setLayout(new BorderLayout(2, 1));
        }
 
    	if(!ReadFile)//if not reading a file then ask for number of supervisors
    	{
        Panel thirdPanel = new Panel();
        thirdPanel.add(new JLabel("Number of Supervisors :"));
        supervCountField = new TextField("1", 2);
        supervCountField.addTextListener(new TextFieldListener());
        thirdPanel.add(supervCountField);
        this.getContentPane().add("West", thirdPanel);
  
        Panel fourthPanel = new Panel();
        fourthPanel.add(okButton);
        fourthPanel.add(cancelButton);
        this.getContentPane().add("South", fourthPanel);
        okButton.addActionListener(new ButtonListener());
        cancelButton.addActionListener(new ButtonListener());

        setLocation(parentFrame.getX() + 10, parentFrame.getY() + 10);
  
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    	
    	
        this.pack();

        super.enableEvents(AWTEvent.WINDOW_EVENT_MASK | AWTEvent.KEY_EVENT_MASK);
        // disabling parent frame to provide modality
        parentFrame.setEnabled(false);
        this.setVisible(true);
    	}
    	else
    	{
            //calling alternate function to read file
    		ContMaskTableWindow contmaskWin = new ContMaskTableWindow(
                    parentFrame, fileName);

    	}
    	
 }
 
    class ButtonListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String buttonLabel = e.getActionCommand();

            if (buttonLabel.equals("Browse")) {
                DoFileDialog dfd = new DoFileDialog(InputFileFrame.this,
                        "Please select a file");

                inputFile.setText(dfd.getPath());
            } else if (buttonLabel.equals("OK")) {
                InputFileFrame.this.dispose();
                parentFrame.setEnabled(true);

                if (fileName == null) {
                    fileName = inputFile.getText();
                }
                if (fileName.equals("")) {
                    JOptionPane.showMessageDialog(parentFrame,
                            "No plant file is specified", "No Input Provided!",
                            JOptionPane.ERROR_MESSAGE);
                } else {
                    ContMaskTableWindow contmaskWin = new ContMaskTableWindow(
                            parentFrame, fileName, noOfSuperv, machine);

                    contmaskWin.setLocationRelativeTo(parentFrame);
                }
            } else if (buttonLabel.equals("Cancel")) {
                InputFileFrame.this.dispose();
                fileName = null;
                parentFrame.setEnabled(true);
            }
        }    
    }// end of ButtonListener class


    class TextFieldListener implements TextListener {
        public void textValueChanged(TextEvent e) {
            try {
                noOfSuperv = Integer.parseInt(supervCountField.getText());
            } catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(parentFrame,
                        "Please input \"Number of Supervisors\" in proper format (Integer format).",
                        "Input Error!", JOptionPane.ERROR_MESSAGE);
                return;
            }     
        }
    }// end of TextFieldListener class..
 
}// end of InputFileFrame
