#include "fsm.h"
#include "converter.h"
/*==========================================================================
Function: Containment();
Comments: This function checks for the containment property of the event
	  labels in the service specification at the co-ordinate y and the 
	  event labels in the composed system (x,y). If the event labels
	  in A are not a subset of the event labels in the composed system
	  then that state is declared as a bad state.
Input:	  LabelList - list of events in a system
	  ServLabelList - list of events in a service specification or
	  another fsm.
Output:	  TRUE if it is a subset, false otherwise.
Author:	  Sudhir Nelvagal
Advisor:  Dr. Ratnesh Kumar
============================================================================*/
int Containment(char *LabelList[MAX_LENGTH], char *ServLabelList[MAX_LENGTH])
{
	int i=0,j=0,match_found=0,match_notfound=0;

	/* If the LabelList is blank, then it means that all the transitions
	   are internal transitions.  In which case return true for subset
	   as these do not matter in our case */

	if(*LabelList[0] == '\0') {
		return(NotSubSet);  
	}

	/* Now comapre the event labels in the lists and determine whether
	they are subsets or not */

	while(*ServLabelList[i]!='\0') {
		while(*LabelList[j]!='\0') {
			if(strcmp(ServLabelList[i], LabelList[j])==0) {
				match_found++;
			}
			else {
				match_notfound++;
			}
			j++; /* point j to the next element*/
		}
		j=0;i++; /* point i to the next element */
	}
	if(match_found ==i) {
		return(SubSet);
	}
	else {
		return(NotSubSet);
	}	
} /* containment ends */
