void Reachability(char *ifile1, char *ifile2, int twofiles, FILE *f10)
{
        FILE *f1, *f2;
        FSM fsm1;
        int no_of_states;
        NAME_LIST *name_list = NULL, *name_ptr;

        /* First an illustration of the reachability function */
        
        if(!twofiles)  /*if didn't pass file names in argument, open default*/
        {
                ifile1 = "../data/reach.data";
                ifile2 = "../data/reach.results";
        }
        f1 = fopen(ifile1, "r");
        f2 = fopen(ifile2, "w");

        fsm_read(f1, &fsm1);

        /* To find out all the states reachable from the initial state */
        no_of_states = fsm_reachability(&fsm1, fsm1.states->name,
                                                "ALL", &name_list); 
        fprintf(f2, "Number of states reachable from the initial state %s is", fsm1.states->name);
        fprintf(f2, "\t %d \n\n", no_of_states);
        fprintf(f2, "These states are: \n\n");
        
        name_ptr = name_list;
        
        while (name_ptr) {
             fprintf(f2, "%s \t", name_ptr->name);
             name_ptr = name_ptr->next;
        }
        fprintf(f2, "\n");

        /* delete the name list now */
        delete_name(&name_list);

        /* now delete the state machine  and close the input file */
        fsm_delete(&fsm1);
        fclose(f1);
        fclose(f2);

        fprintf(f10, "Reachability input file:\n\t %s \n", ifile1);
        fprintf(f10, "Reachability output file:\n\t %s \n\n\n", ifile2);

        /*end a*/
}
