void NDFSM_to_DFSM(char *ifile1, char *ifile2, int twofiles, FILE *f10)
{
        FILE *f1, *f3;
        FSM fsm1, fsm3;
        
        /* To convert a non-deterministic machine to a deterministic one */
        
        if(!twofiles)
        {
                ifile1 = "../data/ndfsm_to_dfsm.data";
                ifile2 = "../data/ndfsm_to_dfsm.results";
        }       
        f1 = fopen(ifile1, "r");
        f3 = fopen(ifile2, "w");

        fsm_read(f1, &fsm1);
        fsm_deterministic(&fsm1, &fsm3);
        fsm_print(f3, &fsm3);
                                
        fclose(f1);
        fclose(f3);
        fsm_delete(&fsm1);
        fsm_delete(&fsm3);
                                        
        fprintf(f10, "Non-deterministic fsm as input file:\n\t %s \n", ifile1);
        fprintf(f10, "Deterministic fsm output file:\n\t %s \n\n\n", ifile2);
                        
        /*end d*/
}
