/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.Desktop;
import flap.Params;
import flap.State;
import flap.Transition;
import java.awt.Point;

class Popup {
    static final int MAKE_INITIAL = 0;
    static final int MAKE_FINAL = 1;
    static final int MAKE_NONFINAL = 2;
    static final int RENAME_STATE = 3;
    static final int REMOVE_STATE = 4;
    static final int RENAME_TRANSITION = 5;
    static final int REMOVE_TRANSITION = 6;
    static int NO_OF_TRANS_ITEMS = 2;
    static int NO_OF_STATE_ITEMS = 5;
    Desktop parent;
    int offx = 9;
    int offy = 5;
    String[] theItems = new String[]{"Make This State Initial", "Make This State Final", "Make This State Non-Final", "Rename This State", "Remove This State", "Rename This Transition", "Remove This Transition"};
    boolean[] isValid;
    int stateItemsCounter;
    int transItemsCounter;
    int itemsCounter;
    int height;
    int width;
    int hasFocus;
    Point p;
    State s = null;
    Transition t = null;
    boolean rename = false;

    Popup(Desktop desktop) {
        this.parent = desktop;
        this.itemsCounter = this.theItems.length;
        this.stateItemsCounter = NO_OF_STATE_ITEMS;
        this.transItemsCounter = NO_OF_TRANS_ITEMS;
        this.isValid = new boolean[this.itemsCounter];
        this.width = Params._p_width;
        this.p = new Point(0, 0);
        this.height = Params._p_height;
        this.invalidateAll();
    }

    public void setState(State state) {
        this.s = state;
        if (state.isFinal) {
            this.isValid[2] = true;
        } else {
            this.isValid[1] = true;
        }
        if (state != this.parent.initialState) {
            this.isValid[0] = true;
        }
        this.isValid[4] = true;
        this.isValid[3] = true;
    }

    public void setTransition(Transition transition) {
        this.t = transition;
        this.isValid[5] = true;
        this.isValid[6] = true;
    }

    public void invalidateAll() {
        this.hasFocus = -1;
        this.s = null;
        this.t = null;
        for (int i = 0; i < this.itemsCounter; ++i) {
            this.isValid[i] = false;
        }
    }

    public boolean takeAction() {
        boolean bl = false;
        switch (this.hasFocus) {
            case 1: {
                if (!this.isValid[1] || this.s == null) break;
                this.s.isFinal = true;
                this.s.rename = false;
                bl = true;
                break;
            }
            case 2: {
                if (!this.isValid[2] || this.s == null) break;
                this.s.isFinal = false;
                this.s.rename = false;
                bl = true;
                break;
            }
            case 0: {
                if (!this.isValid[0] || this.s == null) break;
                this.parent.initialState = this.s;
                this.s.rename = false;
                bl = true;
                break;
            }
            case 4: {
                if (this.isValid[4] && this.s != null) {
                    int n = 0;
                    while (n < this.parent.theTransitions.size()) {
                        Transition transition = (Transition)this.parent.theTransitions.elementAt(n);
                        if (transition.from == this.s || transition.to == this.s) {
                            this.parent.removeTransition(transition);
                            continue;
                        }
                        ++n;
                    }
                    if (this.s == this.parent.initialState) {
                        this.parent.initialState = null;
                    }
                    this.parent.theStates.removeElement(this.s);
                    this.s.rename = false;
                    bl = true;
                }
                if (!this.parent.autoRelabel) break;
                this.parent.relabel();
                break;
            }
            case 6: {
                if (!this.isValid[6] || this.t == null) break;
                this.parent.removeTransition(this.t);
                this.t.rename = false;
                bl = true;
                break;
            }
            case 3: {
                if (this.isValid[3] && this.s != null) {
                    this.parent.selectedState = this.s;
                    this.parent.selectedState.rename = true;
                    bl = true;
                }
                this.rename = false;
                break;
            }
            case 5: {
                if (!this.isValid[5] || this.t == null) break;
                this.parent.selectedTransition = this.t;
                this.parent.selectedTransition.rename = true;
                bl = true;
                break;
            }
            default: {
                if (this.s != null) {
                    this.s.rename = false;
                }
                if (this.t == null) break;
                this.t.rename = false;
            }
        }
        return bl;
    }

    public void setLocation(int n, int n2) {
        this.p.x = n;
        this.p.y = n2;
    }

    public Point writeHere(int n) {
        int n2 = this.p.x + this.offx;
        int n3 = this.p.y + (n + 1) * this.height - this.offy;
        return new Point(n2, n3);
    }
}

