/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.Desktop;
import flap.FSA;
import flap.Machine;
import flap.Params;
import flap.State;
import flap.Transition;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class MyFileReader {
    public Machine a = null;
    protected Desktop d = null;
    protected BufferedReader dis = null;

    public void read(String string) throws Exception {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        this.setStream(fileInputStream);
        this.parseStream();
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        if (this.dis != null) {
            this.dis.close();
        }
    }

    public void setStream(InputStream inputStream) {
        this.dis = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void parseStream() throws Exception {
        Object object;
        int n;
        Vector<String> vector = new Vector<String>(4, 1);
        String string = this.readNextLine();
        if (string == null) {
            throw new EOFException("Wrong File Format");
        }
        int n2 = Integer.parseInt(string);
        this.d = new Desktop();
        if (n2 == 0) {
            throw new Exception("No Initial State");
        }
        for (n = 0; n < n2; ++n) {
            State state = new State();
            state.id = n;
            string = this.readNextLine();
            if (string == null) {
                throw new EOFException("Wrong File Format");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() != 3) {
                throw new EOFException("Wrong File Format");
            }
            object = stringTokenizer.nextToken();
            state.SetStateLabel((String)object);
            object = stringTokenizer.nextToken();
            state.isFinal = Integer.parseInt((String)object) == 1;
            object = stringTokenizer.nextToken();
            state.transitionCount = Integer.parseInt((String)object);
            this.d.theStates.addElement(state);
            if (n == 0) {
                this.d.initialState = state;
            }
            for (int i = 0; i < state.transitionCount; ++i) {
                string = this.readNextLine();
                if (string == null) {
                    throw new EOFException("Wrong File Format");
                }
                vector.addElement(string);
            }
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            object = (State)this.d.theStates.elementAt(i);
            for (int j = 0; j < ((State)object).transitionCount; ++j) {
                string = (String)vector.remove(0);
                if (string == null) {
                    throw new Exception("Error in traversing the file and vectors");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() != 2) {
                    throw new EOFException("Wrong File Format");
                }
                Transition transition = new Transition(++n, (State)object, null, null);
                String string2 = stringTokenizer.nextToken();
                transition.label = null;
                transition.label = string2;
                string2 = stringTokenizer.nextToken();
                transition.to = this.getStateWithLabel(string2);
                if (transition.to == null) {
                    throw new EOFException("Wrong File Format");
                }
                transition.distance = transition.to != transition.from ? Params._t_distance : Params._t_ltheight;
                this.d.theTransitions.addElement(transition);
            }
        }
        this.d.currentId = this.d.theStates.size() + 1;
        this.d.currenttrId = this.d.theTransitions.size() + 1;
        this.dis.close();
        this.a = new FSA(this.d);
        this.setStatePosition();
    }

    protected String readNextLine() {
        try {
            String string = this.dis.readLine();
            while (this.dis.ready() && string.trim().equals("")) {
                string = this.dis.readLine();
            }
            return string;
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.toString() + " caught in readNextLine.");
            return null;
        }
    }

    protected void setStatePosition() {
        int n = (int)Math.sqrt(this.d.theStates.size());
        int n2 = Params._s_radius * n + Params._t_distance * (n - 1);
        int n3 = Params._s_radius * n + Params._t_ltheight * (n - 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = 30;
        int n7 = 55;
        int n8 = Params._s_radius;
        this.d.setSize(n2, n3);
        for (int i = 0; i < this.d.theStates.size(); ++i) {
            n4 = n6 + n8 + i % n * (2 * Params._s_radius + Params._t_distance);
            n5 = n7 + n8 + i / n * (2 * Params._s_radius + Params._t_ltheight);
            State state = (State)this.d.theStates.elementAt(i);
            state.p.x = n4;
            state.p.y = n5;
        }
    }

    protected State getStateWithLabel(String string) {
        for (int i = 0; i < this.d.theStates.size(); ++i) {
            State state = (State)this.d.theStates.elementAt(i);
            if (!state.label.equals(string)) continue;
            return state;
        }
        return null;
    }
}

