/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.DialogThread;
import flap.Environment;
import flap.Params;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class MainMenu
extends Frame {
    static final long serialVersionUID = 1L;
    Vector windows = new Vector(1, 1);
    String paramsFileName = ".flaprc";
    boolean isApplet = false;
    Environment target;
    public static final String STR_FSA = "FSM Designer";
    public static final String STR_QUIT = "QUIT";
    public static final String osName = System.getProperty("os.name");
    public static final String fileSeparator = System.getProperty("file.separator");
    public static String workingDirectory = System.getProperty("user.dir");

    public MainMenu(String[] stringArray, boolean bl) {
        super(STR_FSA);
        this.isApplet = bl;
        this.setLayout(new GridLayout(2, 1));
        Color color = Params._mm_backcolor;
        Button button = new Button(STR_FSA);
        this.add(button);
        button.setBackground(color);
        button = new Button(STR_QUIT);
        this.add(button);
        button.setBackground(color);
        if (stringArray != null) {
            this.parseArgs(stringArray);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.quit(null);
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            if (STR_QUIT.equals(object)) {
                this.target = null;
                DialogThread dialogThread = new DialogThread(this, 5);
                dialogThread.start();
            } else {
                if (!STR_FSA.equals(object)) {
                    return false;
                }
                Environment environment = this.createEnvironment("(no name)");
                environment.setVisible(true);
            }
        } else if (event.target instanceof Environment) {
            if ("Close".equals(object)) {
                Environment environment = (Environment)event.target;
                this.windows.removeElement(environment);
                environment.setVisible(false);
            } else if ("Quit Designer".equals(object)) {
                this.target = (Environment)event.target;
                DialogThread dialogThread = new DialogThread(this, 5);
                dialogThread.start();
            }
        }
        return super.action(event, object);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Params._mm_width, Params._mm_height);
    }

    public boolean quit(Object object) {
        Environment environment;
        if (object != null) {
            environment = (Environment)object;
            environment.setVisible(true);
            if (!environment.testSavedAndProceed()) {
                return false;
            }
            this.windows.removeElement(environment);
            environment.setVisible(false);
        }
        int n = 0;
        while (n < this.windows.size()) {
            environment = (Environment)this.windows.elementAt(n);
            environment.setVisible(true);
            if (!environment.testSavedAndProceed()) {
                return false;
            }
            this.windows.removeElement(environment);
            environment.setVisible(false);
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    void parseArgs(String[] stringArray) {
        int n = 0;
        String string = "(no name)";
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith("-")) continue;
            String string2 = stringArray[n++];
            if (n == 1) {
                if (string2.equalsIgnoreCase("-p") && n < stringArray.length && !stringArray[n].startsWith("-")) {
                    this.paramsFileName = stringArray[n++];
                }
                this.readParams();
            }
            if (n < stringArray.length && !stringArray[n].startsWith("-")) {
                string = stringArray[n++];
            }
            if (!string2.equalsIgnoreCase("-fa")) continue;
            this.createEnvironment(string);
        }
    }

    protected void readParams() {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.paramsFileName);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("jflap: unable to open file " + this.paramsFileName);
            return;
        }
        Params.load(properties);
    }

    protected Environment createEnvironment(String string) {
        this.setCursor(3);
        Environment environment = new Environment(string, this, this.isApplet);
        environment.setSize(Params._e_width + 30, Params._e_height + 30);
        this.windows.addElement(environment);
        environment.setLocation(environment.getX() + 20, environment.getY() + 20);
        this.setCursor(0);
        return environment;
    }

    public void showWindows() {
        Enumeration enumeration = this.windows.elements();
        while (enumeration.hasMoreElements()) {
            Environment environment = (Environment)enumeration.nextElement();
            environment.setVisible(true);
        }
    }

    void threadAction(int n) {
        this.quit(this.target);
    }

    public void OpenFileAsGraphic(String string) {
        Environment environment = this.createEnvironment(string);
        environment.setVisible(true);
    }

    static {
        if (workingDirectory == null) {
            workingDirectory = "";
        } else if (!workingDirectory.endsWith(fileSeparator)) {
            workingDirectory = workingDirectory + fileSeparator;
        }
    }
}

