/*
 * Decompiled with CFR 0.152.
 */
package flap;

import flap.Desktop;
import flap.DialogThread;
import flap.FSA;
import flap.FileWriter;
import flap.HelpDialog;
import flap.InputFileFrame;
import flap.Machine;
import flap.MainMenu;
import flap.MyFileReader;
import flap.OKDialog;
import flap.Params;
import flap.TextInDialog;
import flap.ThreadDialog;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.swing.JOptionPane;
import mainAnalyzer.Analyzer;
import mainAnalyzer.Input;
import mainAnalyzer.InputFrame;

public class Environment
extends Frame {
    static final long serialVersionUID = 1L;
    public String fileName = "(no name)";
    public Desktop d;
    public Machine a;
    public Label statusLine;
    public Choice acceptanceChoice;
    protected Container mainmenu;
    public String currentDir = null;
    public boolean isApplet = false;
    boolean done = false;
    public static final String CLOSE_STR = "Close";
    public static final String QUIT_STR = "Quit Designer";
    public static final String HLP_STATE_STR = "States";
    public static final String HLP_TRANSITION_STR = "Transitions";
    public static final String HLP_OVERVIEW_STR = "Overview";
    public static final String HLP_TRACEWINDOW_STR = "Trace Window";
    public static final String NO_FILE_NAME = "(no name)";
    static final String SAVE_STRING = "Save";
    static final String NOTSAVE_STRING = "Don't Save";
    static final String CANCEL_STRING = "Cancel";
    static final String[] SAVE_BUTTONS = new String[]{"Save", "Don't Save", "Cancel"};
    static final int NEW = 0;
    static final int OPEN = 1;
    static final int FASTRUN = 2;
    static final int PRINT = 3;
    static final int CLOSE = 4;
    static final int SHOWNONDETS = 5;
    static final int OPENGRAPHIC = 6;
    static final int SAVE = 7;
    static final int SAVEAS = 8;
    static final int SHOWASTEXT = 9;
    static final int CONTMASKTABLE = 10;
    static final int QUIT = 11;
    static final int NONE = 99;
    static String MI_NEW = "New";
    static String MI_OPEN = "Open As Text...";
    static String MI_OPEN_GRAPHIC = "Open As Graphic...";
    static String MI_SAVE = "Save";
    static String MI_SAVEAS = "Save As...";
    static String MI_SHOWASTEXT = "Show Text";
    static String CONT_MASK_TABLE = "Controllability/Masking Table";
    private Menu filemenu;

    public Environment(String string, Container container, boolean bl, Desktop desktop) {
        this.setLocation(container.getX() + 40, 20);
        this.isApplet = bl;
        this.mainmenu = container;
        this.setBackground(Params._e_backcolor);
        this.d = desktop == null ? new Desktop() : desktop;
        this.add("Center", this.d);
        this.a = new FSA(this.d);
        this.statusLine = new Label("", 0);
        this.add("South", this.statusLine);
        Panel panel = new Panel();
        this.add("North", panel);
        this.putMenuBar();
        if (!string.equals(NO_FILE_NAME)) {
            String string2 = string;
            this.fileName = null;
            this.fileName = string2;
            try {
                this.open(string);
                this.updateStatus("Mail any bugs or comments to: rkumar@iastate.edu");
            }
            catch (Exception exception) {
                this.updateStatus("Could not open file " + string2 + ". New file.");
            }
        }
        this.setIconImage(Params._img_icon);
    }

    public Environment(String string, Container container, boolean bl) {
        this(string, container, bl, null);
    }

    public Dimension getgetPreferredSize() {
        return new Dimension(Params._e_width, Params._e_height);
    }

    private void putMenuBar() {
        Menu menu;
        MenuBar menuBar = new MenuBar();
        menuBar.setFont(Params._m_font);
        this.filemenu = menu = new Menu("File");
        menu.setFont(Params._m_font);
        menu.add(new MenuItem(MI_NEW));
        MenuItem menuItem = new MenuItem(MI_OPEN);
        menu.add(menuItem);
        if (this.isApplet) {
            menuItem.disable();
        }
        menuItem = new MenuItem(MI_OPEN_GRAPHIC);
        menu.add(menuItem);
        if (this.isApplet) {
            menuItem.disable();
        }
        menuItem = new MenuItem(MI_SAVE);
        menu.add(menuItem);
        if (this.isApplet) {
            menuItem.disable();
        }
        menuItem = new MenuItem(MI_SAVEAS);
        menu.add(menuItem);
        if (this.isApplet) {
            menuItem.disable();
        }
        menu.addSeparator();
        menuItem = new MenuItem(CLOSE_STR);
        menu.add(menuItem);
        if (this.isApplet) {
            menuItem.disable();
        }
        menuBar.add(menu);
        menu = new Menu("View");
        menuItem = new MenuItem(MI_SHOWASTEXT);
        menu.add(menuItem);
        if (this.isApplet) {
            menuItem.disable();
        }
        menuBar.add(menu);
        menu = new Menu("Table");
        menuItem = new MenuItem(CONT_MASK_TABLE);
        menu.add(menuItem);
        if (this.isApplet) {
            menuItem.disable();
        }
        menuBar.add(menu);
        menu = new Menu("Help");
        menu.setFont(Params._m_font);
        menu.add(HLP_OVERVIEW_STR);
        menu.add(HLP_STATE_STR);
        menu.add(HLP_TRANSITION_STR);
        menuBar.add(menu);
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            DialogThread dialogThread = new DialogThread(this, 4);
            dialogThread.start();
        } else if (event.id == 502 || event.id == 402) {
            this.updateStatus();
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof CheckboxMenuItem) {
            if (object.equals("Auto re-label states")) {
                this.d.autoRelabel = ((CheckboxMenuItem)event.target).getState();
                this.d.relabel();
            }
        } else if (event.target instanceof MenuItem) {
            if (object.equals(MI_NEW)) {
                DialogThread dialogThread = new DialogThread(this, 0);
                dialogThread.start();
            } else if (MI_OPEN.equals(object)) {
                DialogThread dialogThread = new DialogThread(this, 1);
                dialogThread.start();
            } else if (MI_OPEN_GRAPHIC.equals(object)) {
                DialogThread dialogThread = new DialogThread(this, 6);
                dialogThread.start();
            } else if (MI_SAVEAS.equals(object)) {
                DialogThread dialogThread = new DialogThread(this, 8);
                dialogThread.start();
            } else if (MI_SAVE.equals(object)) {
                DialogThread dialogThread = new DialogThread(this, 7);
                dialogThread.start();
            } else if (QUIT_STR.equals(object)) {
                DialogThread dialogThread = new DialogThread(this, 11);
                dialogThread.start();
            } else if (CLOSE_STR.equals(object)) {
                DialogThread dialogThread = new DialogThread(this, 4);
                dialogThread.start();
            } else if (MI_SHOWASTEXT.equals(object)) {
                DialogThread dialogThread = new DialogThread(this, 9);
                dialogThread.start();
            } else if (CONT_MASK_TABLE.equals(object)) {
                if (this.fileName != null && !this.fileName.toString().trim().equals("") && !this.fileName.toString().equals(NO_FILE_NAME)) {
                    DialogThread dialogThread = new DialogThread(this, 10);
                    dialogThread.start();
                } else {
                    JOptionPane.showMessageDialog(this, "A FSM file has to be opened before running this.", "No FSM file", 0);
                }
            } else if ("Re-label states".equals(object)) {
                this.relabel();
            } else if (HLP_STATE_STR.equals(object)) {
                this.help(5);
            } else if (HLP_TRANSITION_STR.equals(object)) {
                this.help(15);
            } else if (HLP_OVERVIEW_STR.equals(object)) {
                this.help(0);
            } else {
                OKDialog oKDialog = new OKDialog("This feature is not implemented", this, "Sorry...");
                oKDialog.setVisible(true);
            }
        }
        this.repaint();
        return super.action(event, object);
    }

    public void relabel() {
        this.a.d.relabel();
        this.a.d.repaint();
        this.updateStatus("Relabel completed.");
    }

    void newone() {
        if (!this.testSavedAndProceed()) {
            return;
        }
        this.remove(this.d);
        this.d = new Desktop();
        this.a = new FSA(this.d);
    }

    public void help(int n) {
        HelpDialog helpDialog = new HelpDialog(n, this);
        helpDialog.pack();
        helpDialog.setVisible(true);
    }

    public boolean openText(String string) {
        boolean bl = true;
        if (!this.testSavedAndProceed()) {
            return false;
        }
        if (string == null) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Open FA", 0);
            fileDialog.setBackground(Params._dg_backcolor);
            if (!MainMenu.workingDirectory.endsWith(MainMenu.fileSeparator)) {
                fileDialog.setDirectory(MainMenu.workingDirectory + MainMenu.fileSeparator + "../data/");
            } else {
                fileDialog.setDirectory(MainMenu.workingDirectory + "../data/");
            }
            fileDialog.setVisible(true);
            String string2 = fileDialog.getFile();
            String string3 = fileDialog.getDirectory();
            if (string3 == null || string2 == null) {
                return false;
            }
            if (string2.endsWith(".*.*")) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            if (!string3.endsWith(MainMenu.fileSeparator)) {
                string3 = string3 + MainMenu.fileSeparator;
            }
            this.currentDir = string3;
            string = string3 + string2;
        }
        if (string.equals(NO_FILE_NAME)) {
            JOptionPane.showMessageDialog(this, "No file is opened.", "Error", 0);
        } else {
            InputFrame inputFrame = new InputFrame(new Input(Analyzer.flapMainMenu), string, string);
            inputFrame.setLocation(this.d.getX() + 60, this.d.getY() + 40);
        }
        return bl;
    }

    public boolean OpenGraphic() {
        if (!this.testSavedAndProceed()) {
            return false;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Open FA", 0);
        fileDialog.setBackground(Params._dg_backcolor);
        if (!MainMenu.workingDirectory.endsWith(MainMenu.fileSeparator)) {
            fileDialog.setDirectory(MainMenu.workingDirectory + MainMenu.fileSeparator + "../data/");
        } else {
            fileDialog.setDirectory(MainMenu.workingDirectory + "../data/");
        }
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string2 == null || string == null) {
            return false;
        }
        if (string.endsWith(".*.*")) {
            string = string.substring(0, string.length() - 4);
        }
        if (!string2.endsWith(MainMenu.fileSeparator)) {
            string2 = string2 + MainMenu.fileSeparator;
        }
        String string3 = string2 + string;
        MyFileReader myFileReader = new MyFileReader();
        try {
            myFileReader.read(string3);
            if (myFileReader.a != null) {
                myFileReader.d.setSize(this.getSize());
                this.a = myFileReader.a;
                this.remove(this.d);
                this.d = this.a.d;
                this.add("Center", this.d);
                this.fileName = null;
                this.fileName = string3;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
        return true;
    }

    public void writefiletoTextArea(String string) throws Exception {
    }

    public void open(String string) throws Exception {
        MyFileReader myFileReader = new MyFileReader();
        myFileReader.read(string);
        if (myFileReader.a != null) {
            this.a = myFileReader.a;
            this.remove(this.d);
            this.d = this.a.d;
            this.add("Center", this.d);
        }
    }

    public boolean save() {
        String string = this.a.checkMachine();
        if (string != null) {
            OKDialog oKDialog = new OKDialog(string + "\nOperation canceled.", this, "FA Save Error");
            oKDialog.setVisible(true);
            return false;
        }
        if (NO_FILE_NAME.equals(this.fileName)) {
            return this.saveAs();
        }
        return this.save(this.fileName);
    }

    public boolean saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save FA", 1);
        if (!MainMenu.workingDirectory.endsWith(MainMenu.fileSeparator)) {
            fileDialog.setDirectory(MainMenu.workingDirectory + MainMenu.fileSeparator + "../data/");
        } else {
            fileDialog.setDirectory(MainMenu.workingDirectory + "../data/");
        }
        fileDialog.setBackground(Params._dg_backcolor);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string2 == null || string == null) {
            return false;
        }
        if (string.endsWith(".*.*")) {
            string = string.substring(0, string.length() - 4);
        }
        if (!string2.endsWith(MainMenu.fileSeparator)) {
            string2 = string2 + MainMenu.fileSeparator;
        }
        this.currentDir = string2;
        String string3 = string2 + string;
        return this.save(string3);
    }

    public boolean save(String string) {
        boolean bl = false;
        FileWriter fileWriter = new FileWriter(this.a);
        try {
            if (string.trim().endsWith(MainMenu.fileSeparator)) {
                throw new Exception("Not a valid file name.\n");
            }
            fileWriter.write(string);
            this.fileName = null;
            this.fileName = string;
            this.a.d.modified = false;
            this.updateStatus("File saved");
            bl = true;
        }
        catch (IOException iOException) {
            OKDialog oKDialog = new OKDialog("I/O Error.\nFile not saved.\n" + iOException.getMessage(), this, "FA Save Error");
            oKDialog.setVisible(true);
        }
        catch (NoSuchElementException noSuchElementException) {
            OKDialog oKDialog = new OKDialog("Tokenizer Error.\nFile not saved.\n" + noSuchElementException.getMessage(), this, "FA Save Error");
            oKDialog.setVisible(true);
        }
        catch (Exception exception) {
            OKDialog oKDialog = new OKDialog("File Error.\nFile not saved.\n" + exception.getMessage(), this, "FA Save Error");
            oKDialog.setVisible(true);
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.filemenu.setEnabled(bl);
    }

    public void quit() {
        this.mainmenu.postEvent(new Event(this, 1001, QUIT_STR));
    }

    public void close() {
        if (!this.testSavedAndProceed()) {
            return;
        }
        this.mainmenu.postEvent(new Event(this, 1001, CLOSE_STR));
    }

    public void updateStatus() {
        String string = "Finite State Automaton";
        String string2 = this.a.d.modified ? "(modified)" : "";
        this.setTitle(string + ": " + this.fileName + " " + string2);
        this.statusLine.setText("");
    }

    public void updateStatus(String string) {
        this.updateStatus();
        this.statusLine.setText(string);
    }

    public boolean testSavedAndProceed() {
        boolean bl = true;
        if (this.isApplet) {
            bl = true;
        } else if (this.a.d.modified) {
            String string;
            TextInDialog textInDialog = new TextInDialog("Current machine is not saved", SAVE_BUTTONS, this, "FA Warning");
            Thread thread = Thread.currentThread();
            textInDialog.setDialogThread(thread);
            textInDialog.setLocation(this.mainmenu.getX() + 65, 100);
            textInDialog.setVisible(true);
            if (textInDialog.getPushedButton().equals(ThreadDialog.NOT_YET)) {
                thread.suspend();
            }
            if ((string = textInDialog.getPushedButton()).equals(SAVE_STRING)) {
                if (!this.save()) {
                    bl = false;
                }
            } else if (string.equals(CANCEL_STRING)) {
                bl = false;
            }
        }
        return bl;
    }

    public void threadAction(int n) {
        switch (n) {
            case 1: {
                this.openText(null);
                break;
            }
            case 4: {
                this.close();
                break;
            }
            case 0: {
                this.newone();
                break;
            }
            case 6: {
                this.OpenGraphic();
                break;
            }
            case 7: {
                this.save();
                break;
            }
            case 8: {
                this.saveAs();
                break;
            }
            case 11: {
                this.quit();
                break;
            }
            case 9: {
                this.openText(this.fileName);
                break;
            }
            case 10: {
                if (!this.testSavedAndProceed()) break;
                InputFileFrame inputFileFrame = new InputFileFrame(this, this.fileName, this.a);
                break;
            }
            default: {
                System.out.println("threadAction is called with id = " + n);
            }
        }
    }
}

