%save pgm files to an arf or save array of images as arf
%arg0: output file name
%Set invert = 1
%arg1: input file name or input image array
%arg2,arg3 ; starting and ending file number in case saving from pgm files

function savearf(arg0,invert,arg1,arg2,arg3)

%fname = sprintf('%s%s',arg0,'.arf');  arf file name has same extension as pgm output
fname = arg0;
fp = fopen(fname,'w');
nbits=0;
switch (nargin)
case 3
    images = arg1;
    imwr  = permute(images,[2,1,3]);
    height = size(images,1);
    width = size(images,2);
    totframes = size(images,3);
    writearfhead(fp,height,width,nbits,totframes,invert)
    fwrite(fp,imwr);
case 5  %read from pgm file
    %if (nargin==3)  %arf file name has same extension
    %   arg3 = arg2;
    %   arg2 = arg1;
    %  arg1 = arg0;
    %end
    fnr = sprintf('%s%.4d%s',arg1,arg2,'.pgm')
    im = loadpgm(fnr);
    imwr = im';
    height = size(im,1);
    width = size(im,2);
    totframes = arg3-arg2+1;
    writearfhead(fp,height,width,nbits,totframes,invert)    
    fwrite(fp,imwr);
    for i = arg2+1 :arg3
        fnr = sprintf('%s%.4d%s',arg1,i,'.pgm');
        im = loadpgm(fnr);
        imwr = im';
        fwrite(fp,imwr);
    end
case {1,4}
    disp('No of input arguments incorrect')
end     
