%[images] = loadarf(fname,invert,arg2,arg3) 
%load arf file into an array of images. 
% 3 arguments : arg2 is total no if images from start
% 4 arguments : load images arg2 to arg3

function [images] = loadarf(fname,invert,arg2,arg3)
disp('last 11 frames are junk')
fp = fopen(fname,'r')
if (nargin==1)
    invert = 0;
end
switch (invert)
case {0,1}
    [height ,width, nbits, totframes]  = readarfhead(fp,invert);   
otherwise
    disp('Argument 2 should either 1 or 0')
    return
end

switch (nargin)
case {1,2} % read whole file
    tot = totframes;
case 3 %read first arg2 frames
    tot = arg2;
case 4
    junk = fseek(fp,height*width*(arg2-1),'cof');    
    tot = arg3-arg2+1;
end

images = zeros(height,width,tot);
for i = 1:tot
    images(:,:,i)=fread(fp,[width height],'uchar')';
end

