%Obtain centroid and bounding box for each detected object in the pgm file
% input : segmented pgm file 
% Also display bounding box on corresponding video (avi or arf)
%output: boxes{1:T}

start=7800; stop=8380;
boxes = cell(1,stop);
%mergedboxes = cell(1,stop);
basename = '/fs/hai/output11/out11_'
T=100;
origfile = '/fs/hai/arf/avi11.arf'; 
invert=0; % FOR UNIX  , FOR PC invert=1
%origfile = 'D:\users\nami\haicapture.08.avi'
fp = fopen(origfile);
[height,width,nbits,totframes] = readarfhead(fp,invert);
fseek(fp,(start-1)*height*width,'cof');
 for t = start:stop
  fn = sprintf('%s%.4d.pgm',basename,t);
  bw = loadpgm(fn);
  imorig=fread(fp,[width height],'uchar')';
%  mov=aviread(origfile,t); imorig=double(squeeze(mov.cdata(:,:,1))); 
  frameno=sprintf('Frame No %d',t); 
    figure(1); imshow(imorig/255); title(frameno)
    figure(2);     imshow(imorig/255); title(frameno);
  P=10; bw2 = bwareaopen(bw,P); 
  label = bwlabel(bw2);
  tot = max(max(label));
  ct=1; mct=1;
    merged=0;
    thr = 3;
  for i = 1:tot
    [r,c] = find(label==i);
    cx= (min(c)+max(c))/2; cy = (min(r)+max(r))/2; sx = max(c)-min(c); sy = max(r)-min(r);
    if (sx>1) & (sy>1)
        boxes{t}(ct,1:4) = [cx,cy,sx,sy];
        ct = ct +1;
       figure(1);   rectangle('Position',[min(c),min(r),sx,sy])
        if (ct==2)
            merged(mct,1:4) = [cx,cy,sx,sy];
            oldrows = r; oldcols = c;
            mct = mct + 1;
        else
            old = merged(mct-1,:);
            if  ( abs(old(1)-cx) < (old(3)+sx)/2 + thr ) & ( abs(old(2)-cy) < (old(4)+sy)/2 +thr )
                r=[oldrows; r] ; c = [oldcols; c] ;
                cx = (min(c)+ max(c) )/2;
                cy = (min(r)+ max(r) )/2;
                sx = max(c) - min(c);
                sy = max(r) - min(r);
                merged(mct-1,:) = [cx,cy,sx,sy];
                oldrows = r; oldcols = c;
            else
                merged(mct,1:4) = [cx,cy,sx,sy];
                oldrows = r; oldcols = c;
                mct = mct + 1;
            end        
        end        
    end    
  end
  umsz(t)= size(boxes{t},1);
  if size(merged,2)==4
      mergedboxes{t}=merged;
      msz(t) = size(mergedboxes{t},1);
  else
      msz(t) = 0;
  end  
  for mct = 1:msz(t)
      cx=merged(mct,1); cy = merged(mct,2); sx = merged(mct,3); sy = merged(mct,4);
      figure(2);   rectangle('Position',[cx-sx/2,cy-sy/2,sx,sy])
  end
  %pause
  %mov(t-start+1) = getframe; takes too much memory for long segments
 end
