%Obtain centroid and bounding box for each detected object in the pgm file
% input : segmented pgm file 
% Also display bounding box on corresponding video (avi or arf)
%output: boxes{1:T}

%start=4400; stop=4800;
basename = '/fs/hai/output11/out11_'
T=100;
origfile = '/fs/hai/arf/avi11.arf'; 
invert=0; % FOR UNIX invert = 1 for PC

fp = fopen(origfile);
[height,width,nbits,totframes] = readarfhead(fp,invert);
fseek(fp,(start-1)*height*width,'cof');
 for t = start:stop
  fn = sprintf('%s%.4d.pgm',basename,t);
  bw = loadpgm(fn);
  imorig=fread(fp,[width height],'uchar')';
%  mov=aviread(origfile,t); imorig=double(squeeze(mov.cdata(:,:,1))); 
  figure(1); imshow(imorig/255);
  frameno=sprintf('Frame No %d',t); title(frameno)
    figure(2);     imshow(bw);
  P=10; bw2 = bwareaopen(bw,P); 
  label = bwlabel(bw2);
  tot = max(max(label));
  ct=1;
  for i = 1:tot
    [r,c] = find(label==i);
    cx= (min(c)+max(c))/2; cy = (min(r)+max(r))/2; sx = max(c)-min(c); sy = max(r)-min(r);
    if (sx>1) & (sy>1)
        %centy{t}(ct) = cy;
        %centx{t}(ct) = cx;
        %sizey{t}(ct) = sy;
        %sizex{t}(ct) = sx;
        boxes{t}(ct,1:4) = [cx,cy,sx,sy];
        ct = ct +1;
     figure(1);   rectangle('Position',[min(c),min(r),sx,sy])
    end    
  end
  ct-1;
  pause(.3)
  %mov(t-start+1) = getframe; takes too much memory for long segments
 end
