% Convert bmp files to pgm files
% Date: 15 June 2002
% Input bmp files should be in a directory "bmpfiles" relative to current directory
% Create a new directory "pgmfiles" for output pgm files relative to current directory

close all;
clear all;
format compact;

strbmp ='D:/users/nami/bmp/';
strpgm = 'D:/users/nami/pgm/';

required = 2; % . and .. directories
extra = 0; % no. of extra files or directories in directory "bmpfiles" apart from bmp files
d = dir(strbmp);
num = size(d,1) - (extra + required);


for i=1:num   % no. of images
    str1 = getfield(d,{i+required,1},'name');
    len = size(str1,2);
    str2 = str1;
    str2(len) ='m'; 
    str2(len-1) ='g'; 
    str2(len-2) ='p' ;
    
    str1 = strcat(strbmp,str1);
    im = imread(str1);
    if(size(im,3)~=1)
        im = squeeze(im(:,:,1));
    end
    %figure;imshow(im);
    str2 = strcat(strpgm,str2);
    [rows,cols] = size(im);
    fid=fopen(str2,'w');
    fprintf(fid,'P5\n%d %d\n255\n',cols,rows);
    count=fwrite(fid,im','uchar');
    fclose(fid);
    if (i==1)
      disp(sprintf('file read   ->%s',str1));    
      disp(sprintf('file written->%s',str2));        
    end
end

