function state = setstate(Ct,vt,wtilde,wt)
state.Ct = Ct; state.vt = vt; state.wtilde = wtilde; state.wt = wt;

function [Ct,vt,wtilde,wt] = getstate(state)
Ct=state.Ct; vt=state.vt; wtilde=state.wtilde; wt=state.wt;

function [Ctmat,vtmat,wtildemat,wtmat] = struct2mat(state)
global M K N T
Ctmat = zeros(M,N,T); vtmat = zeros(M,N,T); wtildemat=zeros(N,T);wtmat=zeros(N,T);
for t = 1:T
    Ctmat(:,:,t) = state(t).Ct;
    vtmat(:,:,t) = state(t).vt;
    wtildemat(:,t) = state(t).wtilde';
    wtmat(:,t) = state(t).wt';
end

function [alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel)
alpha1 = obsmodel.alpha1; alpha2 = obsmodel.alpha2; 
sigobs1 = obsmodel.sigobs1; sigobs2 = obsmodel.sigobs2; 
pf_type = obsmodel.pf_type; pf_paramsa = obsmodel.pf_paramsa; pf_paramsb = obsmodel.pf_paramsb;

function [Bs,Br,Sigs,Sigr] = getsysmodel(sysmodel)
Bs = sysmodel.Bs;  Br = sysmodel.Br;
Sigs = sysmodel.Sigs;  Sigr = sysmodel.Sigr;
