
function [Ctmat,vtmat,wtildemat,wtmat,Cthat,vthat,Neff,logpy] = struct2mat(state,col)
T=length(state);
M= size(state(1).Ct,1);
N= size(state(1).Ct,2);
Ctmat = zeros(M,N,T); vtmat = zeros(M,N,T); wtildemat=zeros(M,N,T);wtmat=zeros(M,N,T);
for t = 1:T
    Ctmat(:,:,t) = state(t).Ct;
    vtmat(:,:,t) = state(t).vt;
    for p=1:M
        wtildemat(p,:,t) = state(t).wtilde';
        wtmat(p,:,t) = state(t).wt';
    end
    epsw = eps(0);
    if (N>1)&(t>1) %do not compute for state_true
        wtilde_nr = state(t).wtilde_nr;   %(state(t).wtilde_nr > epsw).*state(t).wtilde_nr + (state(t).wtilde_nr < epsw)*epsw; %state(t).wtilde_nr;%
        sm0 = sum(wtilde_nr);
        if sm0<epsw
            sm0 = epsw;
        end
        wtnr = wtilde_nr/sm0;
        wtnr2 = wtnr.^2;
        sm = sum(wtnr2);
        if (sm < N*epsw)
            Neff(t) = 0; %sm = epsw;
        else
            tmp = 1/sm;
            if isinf(tmp)
                Neff(t) = 0;
            else
                Neff(t) = real(tmp);
            end
        end
         if ( isnan(Neff(t)) | isinf(Neff(t))  )
            keyboard
         end
         logpy(t) = log( real(sm0) );
    else        
        Neff(t)=1;
        logpy(t) = 1;
    end
end
Cthat=squeeze(sum(Ctmat.*wtmat,2));
vthat=squeeze(sum(vtmat.*wtmat,2));
if nargin==2
    for p = 1:M
        figure(p)
        plot(Cthat(p,:),col); hold on
    end
end