function pfeis(Yt)
randn('state',0), rand('state',0)
%Yt: 2MxT  simulated or real observations (comes from simulation code)
global M K N T
global obsmodel sysmodel
global sqrtSigs sqrtSigr sqrtsigobs1 sqrtsigobs2 one

gendata
N = 10;
%allocate memory
Ct = inf(M,N); vt = inf(M,N); wtilde = inf(1,N);  wt = inf(1,N);
state(1:T,1) = struct('Ct',Ct,'vt',vt,'wtilde',wtilde,'wt',wt);
mt = inf(M-K,1); SigIS = inf(M-K,M-K);
pstar(1:T,1:N) = struct('mt',mt,'SigIS',SigIS);
%Yt: 2MxT  simulated or real observations (comes from simulation code)

%initialize state at t=1  (known initial state)
Ct = zeros(M,N); vt = zeros(M,N); wtilde = ones(1,N); wt = wtilde/N;
state(1)=setstate(Ct,vt,wtilde,wt);

for t = 2:T
    [state(t),pstar(t,:),Lmt ] = impsample(state(t-1),t,Yt); %update Ct, vt in state(t)
    %[state(t)] = weight(state,pstar(t,:),Lmt,t,Yt);  %update wtilde, wt in state(t)
%   [state_resamp] = resample(state,t,Yt);state = state_resamp;
end
keyboard
disp('verify computation of E once')
disp('verify gendata - see if Ct, vt generated properly')
disp('verify gendata - see if Yt generated properly from Ct')

function [state_t,pstar_t,Lmt] = impsample(stateold_t,t,Yt)
global M K N T
global obsmodel sysmodel
global sqrtSigs sqrtSigr sqrtsigobs1 sqrtsigobs2 one
[alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel);
[Bs,Br,Sigs,Sigr] = getsysmodel(sysmodel)
Y=Yt(:,t);

[Ctold,vtold,wtilde,wt] = getstate(stateold_t);
vtsold = vtold(1:K,:); vtrold = vtold(K+1:M,:);
%importance sampling
nuts = sqrtSigs*randn(K,N); 
vts = vtsold +  nuts; % sample vts
Chat = Ctold + Bs*vts;
nutr = sqrtSigr*randn(M-K,N); 
for i = 1:N %saving  pstar, computing L
    mt = vtrold(:,i);
    SigIS = Sigr;
    pstar_t(1,i).mt = mt; pstar_t(1,i).SigIS = SigIS;
    Lmt(i) = computeL(vtr(:,i),Y,Chat(:,i),vtrold(:,i),Br,inv(Sigr));
end
vtr = vtrold +  nutr;
vt = [vts; vtr];
Ct = Chat + Br*vtr;
state_t = setstate(Ct,vt,wtilde,wt);
%*******************************************************

function [state_t] = weight(state,pstar_t,Lmt,t,Yt)
global M K N T
global obsmodel sysmodel
global sqrtSigs sqrtSigr sqrtsigobs1 sqrtsigobs2 one
[alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel);
[Bs,Br,Sigs,Sigr] = getsysmodel(sysmodel)
Y=Yt(:,t);
[Ct,vt] = getstate(state(t));
vtr = vt(K+1:M,:);
for n = 1:N
    mt=pstar_t(1,i).mt; SigIS=pstar_t(1,i).SigIS;
    denom(1,i) =  gauss(mt,SigIS,vtr(:,i));
end
wtilde = wtold.*exp(-Lmt)./denom;
wt = wtilde/sum(wtilde);


function state = setstate(Ct,vt,wtilde,wt)
state.Ct = Ct; state.vt = vt; state.wtilde = wtilde; state.wt = wt;

function [Ct,vt,wtilde,wt] = getstate(state)
Ct=state.Ct; vt=state.vt; wtilde=state.wtilde; wt=state.wt;

function [Ctmat,vtmat,wtildemat,wtmat] = struct2mat(state)
global M K N T
Ctmat = zeros(M,N,T); vtmat = zeros(M,N,T); wtildemat=zeros(N,T);wtmat=zeros(N,T);
for t = 1:T
    Ctmat(:,:,t) = state(t).Ct;
    vtmat(:,:,t) = state(t).vt;
    wtildemat(:,t) = state(t).wtilde';
    wtmat(:,t) = state(t).wt';
end

function [alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel)
alpha1 = obsmodel.alpha1; alpha2 = obsmodel.alpha2; 
sigobs1 = obsmodel.sigobs1; sigobs2 = obsmodel.sigobs2; 
pf_type = obsmodel.pf_type; pf_paramsa = obsmodel.pf_paramsa; pf_paramsb = obsmodel.pf_paramsb;

function [Bs,Br,Sigs,Sigr] = getsysmodel(sysmodel)
Bs = sysmodel.Bs;  Br = sysmodel.Br;
Sigs = sysmodel.Sigs;  Sigr = sysmodel.Sigr;



