global M K Km N T K0
global obsmodel sysmodel one_sensor_per_node squared_sensor
global sqrtSigs sqrtSigr sqrtsigobs1 sqrtsigobs2 one
global pftype %'g' (pf=gordon) 'e' (pfeis) 'm' (pfmt)

%Yt: 2MxT  simulated or real observations (comes from simulation code)
%gendata
%set sysmodel parameters. obsmodel parameters already saved in gendata2.m 
N = Npf; %K = Kpf;

if pftype == 'c'   	
    K = K0; Km = K2;	%PF-EIS-MT
elseif pftype == 'e'
    K = K0; Km = M;	%PF-EIS
elseif pftype == 'm'	
    K = K0; Km = K0; 	%PF-MT
elseif pftype == 'd'
    K = 0; Km = M;    	%PF-Doucet
elseif pftype == 'g'
    K = M; Km = M;	%PF-Gordon
elseif pftype == 's'
   K = K0; Km = K0; %M = K; deal with it separately %PF-Gordon-K dim
end

%disp(pftype), disp([K,Km])

Bs = B(:,1:K); Br = B(:,K+1:M);
alldims = eye(M,M); chooseKdims = alldims(:,1:K); chooserestdims = alldims(:,K+1:M);
Sigs = chooseKdims'*Sig*chooseKdims;
Sigr = chooserestdims'*Sig*chooserestdims;
As = chooseKdims'*A*chooseKdims; Ar = chooserestdims'*A*chooserestdims; %As = Amult*eye(K,K); Ar = Amult*eye(M-K,M-K);
sysmodel = struct('Bs',Bs,'Br',Br,'Sigs',Sigs,'Sigr',Sigr,'As',As,'Ar',Ar);

%save time variables
sqrtSigs = sqrtm(Sigs);
sqrtSigr = sqrtm(Sigr);
sqrtsigobs1 = sqrt(sigobs1);sqrtsigobs2 = sqrt(sigobs2); %sigobs: M-dim vector
one = ones(N,1);


%allocate memory
Ct = inf(M,N); vt = inf(M,N); wtilde = inf(1,N);  wt = inf(1,N); wtilde_nr = inf(1,N); indx = [1:N];
state(1:T,1) = struct('Ct',Ct,'vt',vt,'wtilde',wtilde,'wt',wt,'wtilde_nr',wtilde_nr,'indx',indx);
mt = inf(M-K,1); SigIS = inf(M-K,M-K);
pstar0(1:T,1:N) = struct('mt',mt,'SigIS',SigIS);
pstar = pstar0(1:T,1:N);
%Yt: 2MxT  simulated or real observations (comes from simulation code)

%initialize state at t=1  (known initial state)
Ct = Ct0*ones(M,N); vt = zeros(M,N) ; % + sqrtm(Sig0)*randn(M,N); 
wtilde = ones(1,N); wt = wtilde/N;indx = [1:N];
state(1)=setstate(Ct,vt,wtilde,wt,wtilde_nr,indx);

for t = 2:T
    [state(t),pstar(t,:)] = impsample(state(t-1),t,Yt); %update Ct, vt in state(t)
    [state_resamp] = resample(state(t),t,Yt);
    state(t) = state_resamp;
    % disp('raising pyx to 1/M in computeE')
    % disp('using only first observation of each sensor')
end
disp('changed impsample to ignore exitflag')

%To Do
%wtilde is of little use.. can remove it
%resample multiple times at a single t
%disp('no randn state 0')
%disp('not displaying pyx small at t')
