
function [Deltastar] = computeDeltastar1D(Y,vts, vtrold, Ctold, obsmodel,sysmodel,plotyn)

[alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel);
[Bs,Br,Sigs,Sigr,As,Ar] = getsysmodel(sysmodel);

%Br = eye(M)
%sigobs1 = [5 1 1], sigobs2 = [5 1 1]
%alpha1(1) = 0.4

Chat = Ctold + Bs*vts;

%usual values 0.1, 0.01, 0.01, 0.01
del = 0.1;
epsdetmult = 0.01; epsE11mult = 0.01;
epsLmult = 0.01;
%plotyn= 0;

vtr1vals = [-100: del : 100] + vtrold(1);
VTR1 = vtr1vals;  [nrows, ncols] = size(VTR1); %size returns rows * cols
vtr(1,:) = vtr1vals;
vtr(2,:) = vtrold(2);
vtr(3,:) = vtrold(3);

% computation begins: uses only vtr from top
one = ones(1,ncols*nrows);
%computing pyx
Ct = Chat*one +  Br*vtr;
pyx = one;
for j = 1:M
    %sensor 1
    Y1 = Y(2*j-1);
    pyxj1 = ( alpha1(j)*pdf(pf_type,Y1,pf_paramsa,pf_paramsb) + (1-alpha1(j))*gauss(0,sigobs1(j),( Y1*one-Ct(j,:) )') )';
    %sensor 2
    Y2 = Y(2*j);
    pyxj2 =( alpha2(j)*pdf(pf_type,Y2,pf_paramsa,pf_paramsb) + (1-alpha2(j))*gauss(0,sigobs2(j),( Y2*one-Ct(j,:) )') )';
    % pyxj at location j: product of sensor 1 & sensor 2 pdfs
    pyxj = pyxj1.*pyxj2;
    %computing pyx
    pyx = pyx.*pyxj;
end
%computing E
Evec = -log(pyx);E = reshape(Evec,[nrows, ncols]); %??

% computing grad E, grad D, Hessian E
gradE = gradient(E,del); %:,:,1: indicates derivative wrt vr(1) ??
gradD = vtr(1,:) - vtrold(1);

%compute Hessian of E, compute Econvex region
E11 = gradient( gradE, del );
det = E11;
Econvex =(E11>=0); %all regions where E is convex

%0.01,0.01.0.005
epsE11 = epsE11mult*max(abs(E11(:)));
epsL=epsLmult*max(max(max(abs(gradE))));
epsLs = epsL; %epsL small for computing value of Deltastar: bad idea: changes the min value a lot

%Econvex = (E11>=-epsE11); %modified defn of E convex

dis1 = abs( vtr(1,:) - vtrold(1) ); min1=min(dis1);
[row_vrold, col_vrold] = find( (dis1==min1) );
R_KLC = bwselect(Econvex,col_vrold,row_vrold);  %check if row counted downwards or upwards ??
if isempty(find(R_KLC))
    disp('[vs, vrold] does not belong to a locally convex region of E, breaking,setting Deltastar=-1')
    Deltastar=-1;
    return
end

%Compute  AKp
skipboundary = ones(size(R_KLC)); skipboundary(:,[1,end])=0;
R_KLCc = (~R_KLC)&skipboundary;

D1=gradD;E1=gradE;
AK1 = R_KLCc&( (E1.*D1)<0);
ZK1 = R_KLCc&( (abs(E1)<epsL)&( (E1.*D1)>=0) );% );%    %(abs(D1)<epsL)|

region0 = AK1;
regionlocs = find(region0)';%if use (3:end-2,3:end-2) then change location numbers accordingly
t1 = abs(D1(regionlocs))./( epsLs + abs(E1(regionlocs)) );
Deltastar0 = min(t1);

regionp = ZK1; %&(abs(E1)<epsL)
regionlocs = find(regionp)';
t1 = abs(D1(regionlocs))./( epsLs - abs(E1(regionlocs)) );
Deltastarp = min(t1); %Deltastarp = min(t2)

Deltastar = min([inf,Deltastar0,Deltastarp])

%evaluate result
 Dvec = ( ( vtr(1,:) - vtrold(1)*one ).^2 )/2;
 mul=0.9; sig = (Deltastar*mul);
 Lu = E + Dvec/sig;
 Lu1 = gradient(Lu,del);
  
 mul=1.1; sig = (Deltastar*mul);
 Lm = E + Dvec/sig;
 Lm1 = gradient(Lm,del);
 
 plot(vtr1vals,E,'g'), hold on, plot(vtr1vals,Lu,'b'), plot(vtr1vals,Lm,'r')
 
figure, plot(vtr1vals,E1,'g'), hold on, plot(vtr1vals,Lu1,'b'), plot(vtr1vals,Lm1,'r'), plot(vtr1vals,0*E1,'k')
 

 