function [state_t,pstar_t,Lmt] = impsample(stateold_t,t,Yt)
global M K N T addCt
global obsmodel sysmodel
global sqrtSigs sqrtSigr sqrtsigobs1 sqrtsigobs2 one
global pftype %pfg or pfeis or pfmt
[alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel);
[Bs,Br,Sigs,Sigr,As,Ar] = getsysmodel(sysmodel);
Y=Yt(:,t);
invSigr = inv(Sigr);

[Ctold,vtold,wtildeold,wtold,indxold] = getstate(stateold_t); %read old state
vtsold = vtold(1:K,:); vtrold = vtold(K+1:M,:);

if (K > 0)
    nuts = sqrtSigs*randn(K,N);   % sample vts, compute Chat
    vts = As*vtsold +  nuts;
    Chat = Ctold + Bs*vts;
else %K==0
    vts = vtsold;
    Chat = Ctold;
end

Lmt = inf(1,N);Emt = inf(1,N);pyx=inf(1,N); denom = inf(1,N); numer = inf(1,N);     vtr = inf(M-K,N);
if (pftype=='g')     %pf-gordon
    nutr = sqrtSigr*randn(M-K,N);
    vtr = Ar*vtrold +  nutr;
    vt = [vts; vtr];
    Ct = Chat + Br*vtr;
    for i = 1:N
        mt = Ar*vtrold(:,i);
        SigIS = Sigr;
        pstar_t(1,i).mt = mt; pstar_t(1,i).SigIS = SigIS;
        [Emt(i),pyx(i)] = computeE(vtr(:,i),Y,Chat(:,i),Br);
    end
    wtilde = wtold.*pyx;%wtilde2 = wtold.*exp(-Emt); %wtilde2 = wtold.*exp(-Lmt)./denom; wt2 = wtilde2/sum(wtilde2);
    ss;
elseif (pftype=='s')  %K-dim PF
    % nutr = sqrtSigr*randn(M-K,N);
    vtr = vtrold ; %Ar*vtrold +  nutr;
    vt = [vts; vtr];
    Ct = Chat + Br*vtr;
    for i = 1:N
        mt = Ar*vtrold(:,i);
        SigIS = Sigr;
        pstar_t(1,i).mt = mt; pstar_t(1,i).SigIS = SigIS;
        [Emt(i),pyx(i)] = computeE(vtr(:,i),Y,Chat(:,i),Br);
    end
    wtilde = wtold.*pyx;%wtilde2 = wtold.*exp(-Emt); %wtilde2 = wtold.*exp(-Lmt)./denom; wt2 = wtilde2/sum(wtilde2);
elseif (pftype=='e')  %pf-eis
    nutr01 = randn(M-K,N);
    for i = 1:N
        [Emt0,pyx0] = computeE(vtrold(:,i),Y,Chat(:,i),Br);
        %To Do: compute Hessian of E at vtrold(:,i) and see if it is positive (vtrold lies in locally convex region of E)
        if pyx0 < 1000*eps(0)
            mt = Ar*vtrold(:,i);
            SigIS = Sigr;
            %   disp(['pyx small at time ',num2str(t)])
        else     % [mt,Lmt(i),Hessmt,gradmt(:,i),exitflag(i)] = getmode(Y,Chat(:,i),vtrold(:,i),Br,invSigr);
            [mt0,Lm,Hessmt,gradm,exitflag] = getmode(Y,Chat(:,i),Ar*vtrold(:,i),Br,invSigr);
            if   (exitflag~=-1) %(exitflag>=0)
                lastwarn('');
                if sum( eig(Hessmt)<=0 ) == 0  % Hessmt is positive definite
                    SigIS = inv(Hessmt);  % disp(exitflag),    disp([mt,Ar*vtrold(:,i)]), disp(Y(2*K+1:end)), disp(SigIS)
                    if  (~isempty(lastwarn)) %if there was a warning while trying to invert Hessmt  %dt = det(SigIS); (dt<0) |
                        disp(dt)
                        SigIS = Sigr;
                    end
                    mt = mt0 ; %- SigIS * gradm; % use this if fixing no of Grad descent iterations
                else  %Hessian is negative definite
                    SigIS = Sigr;
                    mt = mt0; % you are not in a convex region, but GD may still work
                end
            else     % if (exitflag==-2), disp(exitflag),    disp([mt,Ar*vtrold(:,i)]), disp(Y(2*K+1:end)), disp(inv(Hessmt)), end
                disp(exitflag),    disp([mt,Ar*vtrold(:,i)]), disp(Y(2*K+1:end)), disp(inv(Hessmt))
                mt = Ar*vtrold(:,i);
                SigIS = Sigr;
            end
        end
        vtr(:,i) = mt + sqrtm(SigIS)*nutr01(:,i);
        [Emt(i),pyx(i)] = computeE(vtr(:,i),Y,Chat(:,i),Br);
        numer(i) = gauss( (Ar*vtrold(:,i))',Sigr,vtr(:,i)');%gauss(mu,covar,X)
        denom(i) =  gauss(mt',SigIS,vtr(:,i)');
        pstar_t(1,i).mt = mt; pstar_t(1,i).SigIS = SigIS;
    end
    vt = [vts; vtr];
    Ct = Chat + Br*vtr;   %WRONG: wtilde = wtold.*exp(-Lmt)./denom;
    wtilde = wtold.*pyx.*numer./denom;
elseif (pftype=='m')
    for i = 1:N
        [Emt0,pyx0] = computeE(vtrold(:,i),Y,Chat(:,i),Br);
        if pyx0 < 1000*eps(0) %10^(-120) %
            mt = Ar*vtrold(:,i);
            SigIS = Sigr;
            Lmt(i)=Emt0 + 0; %since vtr(:,i)=mt=vtrold(:,i)
            % disp(['pyx small at ',num2str(t)])
        else     % [mt,Lmt(i),Hessmt,gradmt(:,i),exitflag(i)] = getmode(Y,Chat(:,i),vtrold(:,i),Br,invSigr);
            [mt,Lmt(i),Hessmt,gradm,exitflag] = getmode(Y,Chat(:,i),Ar*vtrold(:,i),Br,invSigr);
            if (exitflag~=-1)
                % do nothing
                % SigIS = inv(Hessmt);
            else
                disp(exitflag)
                % disp([mt,vtrold(:,i)]),disp(Y(2*K+1:end))
                mt = Ar*vtrold(:,i);
                % SigIS = Sigr;
            end
            SigIS = Sigr; %not using denom, so need not compute inv(Hessmt)
        end
        vtr(:,i) = mt;   %- SigIS * gradm; % use this if fixing no of Grad descent iterations   % + sqrtm(SigIS)*nutr01(:,i);
        [Emt(i),pyx(i)] = computeE(vtr(:,i),Y,Chat(:,i),Br);
        numer(i) = gauss( (Ar*vtrold(:,i))',Sigr,vtr(:,i)');%gauss(mu,covar,X)
        %  denom(i) =  gauss(mt',SigIS,vtr(:,i)');  %vtr(:,i)=mt but SigIS different for different particles
        pstar_t(1,i).mt = mt; pstar_t(1,i).SigIS = SigIS;
    end
    vt = [vts; vtr];
    Ct = Chat + Br*vtr;
    wtilde = wtold.*pyx.*numer; %./denom; %can remove denom without much error
    %wtilde2 = wtold.*exp(-Lmt)./denom;
    ss;
end
epsw = eps(0);
if (sum(wtilde)<epsw)
    wt = (wtilde+epsw)/sum(wtilde+epsw);
else
    wt = wtilde/sum(wtilde);
end
wtilde_nr = wtilde;
state_t = setstate(Ct,vt,wtilde,wt,wtilde_nr,indxold);
