function [state_t,pstar_t,Lmt] = impsample(stateold_t,t,Yt)
%To Do: compute Hessian of E at vtrold(:,i) and see if it is positive (vtrold lies in locally convex region of E)
global M K Km N T addCt K0
global obsmodel sysmodel
global sqrtSigs sqrtSigr sqrtsigobs1 sqrtsigobs2 one one_sensor_per_node squared_sensor
global pftype

[alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel);
[Bs,Br,Sigs,Sigr,As,Ar] = getsysmodel(sysmodel);
Y=Yt(:,t);
invSigr = inv(Sigr);
[Ctold,vtold,wtildeold,wtold,indxold] = getstate(stateold_t); %read old state
vtsold = vtold(1:K,:); vtrold = vtold(K+1:M,:);

if (K > 0)       % sample vts, compute Chat
    vts = As*vtsold +  sqrtSigs*randn(K,N);
    Chat = Ctold + Bs*vts;
else %K==0 as in PF-Doucet
    vts = vtsold;
    Chat = Ctold;
end

% To Do: MT may be a bad idea if using previous state as mode: unless small enough Sigr

Lmt = inf(1,N);Emt = inf(1,N);pyx=inf(1,N); denom = inf(1,N); numer = inf(1,N);     vtr = inf(M-K,N);

% importance sampling/weighting for pftype == 'g' or 's'
if (pftype == 'g')|(pftype == 's') % if 'g' then K=M, if 's' then K=K0
    vtr = vtrold ;
    vt = [vts]; %  ; vtr];
    Ct = Chat; %+ Br*vtr;
    for i = 1:N
        [Emt(i),pyx(i)] = computeE(vtr(:,i),Y,Chat(:,i),Br);  pstar_t(1,i).mt=Ar*vtrold(:,i); pstar_t(1,i).SigIS=Sigr;
    end
    wtilde = wtold.*pyx;   %wtilde2 = wtold.*exp(-Emt); %wtilde2 = wtold.*exp(-Lmt)./denom; wt2 = wtilde2/sum(wtilde2);
    
% importance sampling/weighting for pftype NOT EQUAL TO 'g' or 's'    
else 
    nutr = randn(Km-K,N);
    for i = 1:N
     %   [Emt0,pyx0] = computeE(vtrold(:,i),Y,Chat(:,i),Br);
      %  if pyx0 < 1000*eps(0),
       %     mt = Ar*vtrold(:,i); SigIS = Sigr;
       % else
            [mt0,Lm,Hessmt,gradm,exitflag] = getmode(Y,Chat(:,i),Ar*vtrold(:,i),Br,invSigr); %compute conditional posterior mode
            if   (exitflag~=-1) %(exitflag>=0)  checking error conditions of "fminunc"
                lastwarn('');
                if sum( eig(Hessmt)<=0 ) == 0  % Hessmt is positive def => can be inverted
                    SigIS0 = inv(Hessmt);  % disp(exitflag),    disp([mt,Ar*vtrold(:,i)]), disp(Y(2*K+1:end)), disp(SigIS)
                    if  (~isempty(lastwarn)) %if there was a warning while trying to invert Hessmt  %dt = det(SigIS); disp(dt)
                        SigIS = Sigr;
                        mt = mt0 ;
                    else
                        SigIS = SigIS0;
                        mt = mt0  - SigIS * gradm; % use this if fixing number of Grad descent iterations
                    end
                else  %Hessian is not positive def => cannot be inverted or cannot IS from it
                    SigIS = Sigr;
                    mt = mt0 ;
                end
            else     % if (exitflag==-2), disp(exitflag),    disp([mt,Ar*vtrold(:,i)]), disp(Y(2*K+1:end)), disp(inv(Hessmt)), end
                disp(exitflag), disp([mt,Ar*vtrold(:,i)]), disp(Y(2*K+1:end)), disp(inv(Hessmt))
                mt = Ar*vtrold(:,i);
                SigIS = Sigr;
            end        %end of checking error conditions  %end %if Emt0 < 1000 eps0 ... , else 
        mts = mt(1:Km-K);  mtr = mt(Km-K+1: end);  %select mts, mtr, for PF-EIS-MT
        SigISs = SigIS(1:Km-K,1:Km-K);  SigISrs = SigIS(Km-K+1:end,1:Km-K);  %select SigISs, SigISrs for PF-EIS-MT
        vtrs = mts + sqrtm(SigISs)*nutr(1:Km-K,i);  %PF-MT: mts and SigISs empty, and so (vtrs - mts) also empty
        vtrr = mtr + SigISrs*inv(SigISs)*(vtrs - mts); %PF-EIS: mtr and SigISrs empty.
        vtr(:,i) = [vtrs; vtrr];  %mt + sqrtm(SigIS)*nutr(:,i);
        [Emt(i),pyx(i)] = computeE(vtr(:,i),Y,Chat(:,i),Br);     pstar_t(1,i).mt = mt; pstar_t(1,i).SigIS = SigIS;
        numer(i) = gauss( (Ar*vtrold(:,i))',Sigr,vtr(:,i)');  %gauss(mu,covar,X)
        denom(i) =  gauss(mt',SigIS,vtr(:,i)');
    end    % for i = 1 : N
    wtilde = wtold.*pyx.*numer./denom;
    vt = [vts; vtr];
    Ct = Chat + Br*vtr;   %WRONG: wtilde = wtold.*exp(-Lmt)./denom;
end  %pftype not equal to 'g' or 's'


epsw = eps(0);
if (sum(wtilde)<epsw)
    wt = (wtilde+epsw)/sum(wtilde+epsw);
else
    wt = wtilde/sum(wtilde);
end
wtilde_nr = wtilde;
state_t = setstate(Ct,vt,wtilde,wt,wtilde_nr,indxold);
