randn('state',100), rand('state',100)
global M K N T
global obsmodel sysmodel
global sqrtSigs sqrtSigr sqrtsigobs1 sqrtsigobs2 one
global pftype %'g' (pf=gordon) 'e' (pfeis) 'm' (pfmt)

M = 10; K = 3;
N = 1; T = Tset;
%Npf = 30; %N used for PF
%obs model
alpha1 = 0.1*ones(M,1); alpha2 = 0.1*ones(M,1);
sigobs1 = 5; sigobs2 = 5;
pf_type = 'unif';
pf_paramsa = -10; pf_paramsb = 10;
obsmodel = struct('alpha1',alpha1,'alpha2',alpha2,'sigobs1',sigobs1,'sigobs2',sigobs2,'pf_type',pf_type,'pf_paramsa',pf_paramsa,'pf_paramsb',pf_paramsb);
%sysmodel
Bfull = eye(M,M);  %any orthonormal matrix
Deltavec = [25*ones(1,K), 2.5*ones(1,M-K)]; Deltafull = diag(Deltavec)
disp('generating random non-identity Bs, Br, but deterministic Deltafull')
A = randn(M,M); [eval,evec] = eigdec(A*A',M);Bfull = evec; 
%Deltavec = eval; Deltafull = diag(Deltavec);
Bs = Bfull(:,1:K); Br = Bfull(:,K+1:M);
alldims = eye(M,M); chooseKdims = alldims(:,1:K); chooserestdims = alldims(:,K+1:M);
Sigs = chooseKdims'*Deltafull * chooseKdims;
Sigr = chooserestdims'*Deltafull * chooserestdims;
As = eye(K,K); Ar = eye(M-K,M-K)
sysmodel = struct('Bs',Bs,'Br',Br,'Sigs',Sigs,'Sigr',Sigr,'As',As,'Ar',Ar);

%allocate memory
Ct = inf(M,N); vt = inf(M,N); wtilde = inf(1,N);  wt = inf(1,N);wtilde_nr = inf(1,N);
state_true(1:T,1) = struct('Ct',Ct,'vt',vt,'wtilde',wtilde,'wt',wt,'wtilde_nr',wtilde_nr);
mt = inf(M-K,1); SigIS = inf(M-K,M-K);
pstar(1:T,1:N) = struct('mt',mt,'SigIS',SigIS);

%save time variables
sqrtSigs = sqrtm(Sigs);
sqrtSigr = sqrtm(Sigr);
sqrtsigobs1 = sqrtm(sigobs1);sqrtsigobs2 = sqrtm(sigobs2);
one = ones(N,1);


%initialize state at t=1  (known initial state)
t=1;
Ct = zeros(M,N); vt = zeros(M,N); wtilde = ones(1,N); wt = wtilde/N;wtilde_nr = inf(1,N);
state_true(t) = setstate(Ct,vt,wtilde,wt,wtilde_nr);
for t = 2:T
    [Ctold,vtold,wtilde,wt] = getstate(state_true(t-1));
    vtsold = vtold(1:K,:); vtrold = vtold(K+1:M,:);
    vts = As*vtsold +  sqrtSigs*randn(K,N);
    vtr = Ar*vtrold +  sqrtSigr*randn(M-K,N);
    vt = [vts; vtr];
    Chat = Ctold + Bs*vts;
    Ct = Chat + Br*vtr;
    state_true(t) = setstate(Ct,vt,wtilde,wt,wtilde_nr);
%    state_true(t).Ct = Ct; state_true(t).vt = Ct; state_true(t).wtilde = wtilde; state_true(t).wt = wt;
    %generate Yt from Ct
    for j = 1:M
        coin = rand;
        if (coin < alpha1(j))
            Y1 = random(pf_type,pf_paramsa,pf_paramsb);
        else
            Y1 = Ct(j) + sqrtsigobs1*randn(1,1);
        end
        coin = rand;
        if (coin < alpha2(j))
            Y2 = random(pf_type,pf_paramsa,pf_paramsb);
        else
            Y2 = Ct(j) + sqrtsigobs2*randn(1,1);
        end
        Yt(2*j-1,t) = Y1; Yt(2*j,t) = Y2;
        clear Y1, clear Y2
    end
end

clear vts vtr vtsold vtrold vt vtold Ct Ctold Chat wtilde wt 
