%extrematype = -1,0,1 for min,inflection,max
function [numextremaregions,extrematype,extrema,zc,eigvals] = findlocmins(L)

[L2,L1] = gradient(L);
%compute second derivative: for computing Hessian
[L12,L11] = gradient(L1);
[L22,L21] = gradient(L2);

mesh(L1)
figure, mesh(L2)

dif = L1;
difneg = dif<=0;
difpos = dif>0;
zcneg = (bwdist(difneg)>0) & (bwdist(difneg)<=1);
zcpos = (bwdist(difpos)>0) & (bwdist(difpos)<=1);
zc = zcneg|zcpos;
zcL1 = zc;

dif = L2;
difneg = dif<=0;
difpos = dif>0;
zcneg = (bwdist(difneg)>0) & (bwdist(difneg)<=1);
zcpos = (bwdist(difpos)>0) & (bwdist(difpos)<=1);
zc = zcneg|zcpos;
zcL2 = zc;

zc = zcL1 & zcL2;
[label,numextremaregions] = bwlabel(zc);
[extrema(1,:),extrema(2,:),vl] = find(zc);

tol = 1e-8;
for i = 1:length(extrema)
    x=extrema(1,i);
    y=extrema(2,i);
    hessian = [L11(x,y), L12(x,y); L21(x,y), L22(x,y)];
    determin(i) = det(hessian);
    if (determin(i)<tol) %either zero or negative
        extrematype(i) = 0;
    else
        evals = eig(hessian);
        eigvals(:,i) = evals;
        if length(find(evals< 0))==0   %no eval < 0
            extrematype(i) = -1;
        else
            extrematype(i) = 1;
        end
    end
end

