%extrematype = -1,0,1 for min,inflection,max
function [numextremaregions,extrematype,extrema,zc,eigvals,extremalocs,isminimum] = findlocmins(L,del)

[L1,L2] = gradient(L,del);
%compute second derivative: for computing Hessian
[L11,L12] = gradient(L1,del);
[L21,L22] = gradient(L2,del);


%figure, contour(L1<=0,[0 0],'b'), hold on, contour(L2<=0,[0 0],'r'), grid minor
figure, contour(L1,[0 0],'b'), hold on, contour(L2,[0 0],'r'), grid minor
dif = L1;
difneg = dif<=0;
difpos = dif>0;
zcneg = (bwdist(difneg)>0) & (bwdist(difneg)<=1);
zcpos = (bwdist(difpos)>0) & (bwdist(difpos)<=1);
zc = zcneg|zcpos;
zcL1 = zc;

dif = L2;
difneg = dif<=0;
difpos = dif>0;
zcneg = (bwdist(difneg)>0) & (bwdist(difneg)<=1);
zcpos = (bwdist(difpos)>0) & (bwdist(difpos)<=1);
zc = zcneg|zcpos;
zcL2 = zc;

zc = zcL1 & zcL2;
[label,numextremaregions] = bwlabel(zc);
[extrema(1,:),extrema(2,:),vl] = find(zc);
[extremalocs] = find(zc);

%test for minima: find if smaller than all 8 nghbrs
%when using this need to use zc=zcneg|zcpos
isminimum = zeros(size(extrema,2),1);
for i = 1:size(extrema,2)
    r = extrema(1,i); c = extrema(2,i);
    if (r>1)&(r<size(L,1)-1)&(c>1)&(c<size(L,2)-1)
        mn=min(min(L(r-1:r+1,c-1:c+1)));
        if L(r,c)<=mn
            isminimum(i) = 1;
        end
    end
end

tol = 1e-6;
for i = 1:size(extrema,2)
    x=extrema(1,i);
    y=extrema(2,i);
    hessian = [L11(x,y), L12(x,y); L21(x,y), L22(x,y)];
    determin(i) = det(hessian);
    if (abs(determin(i))<tol)
        extrematype(i) = 5; %inconclusive test
    else
        evals = eig(hessian);
        eigvals(:,i) = evals;
        if length(find(evals< 0))==0   %no eval < 0
            extrematype(i) = -1;  %min
        elseif length(find(evals> 0))==0
            extrematype(i) = 1;   % max
        else
            extrematype(i) = 0;  %saddle point, min in one direction, max in other
        end
    end
end
2;

