
function [extrema,extremalocs] = findextrema(L,del,epsL)
[L1,L2] = gradient(L,del);
%figure, contour(L1<=0,[0 0],'b'), hold on, contour(L2<=0,[0 0],'r'), grid minor
figure, contour(L1,[0 0],'b'), hold on, contour(L2,[0 0],'r'), grid minor

R1 = (abs(L1)<epsL);
R2 = (abs(L2)<epsL);
Rmin = R1 & R2;
[r,c] = find( Rmin );
extrema(1,:) = r';
extrema(2,:) = c';
extremalocs = find( Rmin )';

figure, imshow(Rmin(end:-1:1,:)); title('(|L1|<epsL)&(|L2|<epsL)')
tmp = double(R1);
tmp(find(R2))=0.5;
figure, imshow(tmp(end:-1:1,:));  title('|L1|<epsL in white, |L2|<epsL overlayed on it in grey')
disp(' L1 may be zero at location r,c and while L2 is zero somewhere in its neighborhood: due to numerical error')

