%[Deltastar] = computeDeltastar(Yt,vs,  vrold, Ctold, obsmodel,sysmodel)
%input to the Delta_star computation routine:
%variables: Yt, Chat (or Cold, vs), vrold
%parameters: Br, obs model

% in current version, vs is perfectly matched
% in a tracking algo, vs will have to be sampled, its value may decide
% which region of E we are in

% If CURRENT BOUND IS LOOSE, REDUCE epsL. IF CURRENT BOUND IS WRONG (TOO
% TIGHT), INCREASE epsL
%Too Loose Bound: may occur because by adding epsL in denom, the value at
%each point changes
% Reason for BOUND BEING WRONG (TOO TIGHT) is E switches from a value
% larger than -epsL to +epsL (or vice versa) in one pixel and we do not
%detect it because we are only looking at regions with abs(E1)<epsL or abs(E2)<epsL
% solution is to increase epsL

% if [vs vrold] is not near the boundary and if there is no tiny non-convex strip inside R_KLC
% then the true value of Deltastar is within 2-3 times the computed value
% detect problem with non-convex strip by increasing epsdet, epsE11

function [Deltastar] = computeDeltastar(Yt,vs,  vrold, Ctold, obsmodel,sysmodel,plotyn)
global M K addCt
disp('added vrold to vtr1vals, vtr2vals')
[alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel);
[Bs,Br,Sigs,Sigr,As,Ar] = getsysmodel(sysmodel);

vrold0 = vrold; 
vrold = Ar*vrold0;

Chat = Ctold + Bs*vs;

%usual values 0.1, 0.01, 0.01, 0.01
del = 0.1;
epsdetmult = 0.001; epsE11mult = 0.001;
epsLmult = 0.01;
%plotyn= 0;

vtr1vals = [-30: del : 30] + vrold(1); %variance of pf is 10^2
vtr2vals = [-35: del : 35] + vrold(2);

l1 = length(vtr1vals); l2 = length(vtr2vals);

[VTR1, VTR2] = meshgrid(vtr1vals,vtr2vals); %VTR1 varies along cols, VTR2 varies along rows
[nrows, ncols] = size(VTR1); %size returns rows * cols
vtr = zeros(M-K,l1*l2);
vtr(1,:) = reshape(VTR1,[1,ncols*nrows]); %takes elements columnwise from VR1
vtr(2,:) = reshape(VTR2,[1,ncols*nrows]);
%VTR1 = reshape(vtr(1,:),[nrows, ncols]); %places elements columnwise %VTR2 = reshape(vtr(2,:),[nrows, ncols]);

% computation begins: uses only vtr from top
one = ones(1,ncols*nrows);
%computing pyx
Ct = Chat*one +  Br*vtr;
if addCt
    pyx = one;
    for j = 1:M
        %sensor 1
        Y1 = Yt(2*j-1);
        %pyxj1 = ( alpha1(j)*pdf(pf_type,Y1,pf_paramsa,pf_paramsb) + (1-alpha1(j))*gauss(0,sigobs1(j),( Y1*one-Ct(j,:) )') )';
        pyxj1 = ( alpha1(j)*pdf(pf_type,( Y1*one-Ct(j,:) )',pf_paramsa,pf_paramsb) + (1-alpha1(j))*gauss(0,sigobs1(j),( Y1*one-Ct(j,:) )') )';
        %sensor 2
        Y2 = Yt(2*j);
        %pyxj2 =( alpha2(j)*pdf(pf_type,Y2,pf_paramsa,pf_paramsb) + (1-alpha2(j))*gauss(0,sigobs2(j),( Y2*one-Ct(j,:) )') )';
        pyxj2 =( alpha2(j)*pdf(pf_type,( Y2*one-Ct(j,:) )',pf_paramsa,pf_paramsb) + (1-alpha2(j))*gauss(0,sigobs2(j),( Y2*one-Ct(j,:) )') )';
        % pyxj at location j: product of sensor 1 & sensor 2 pdfs
        pyxj = pyxj1.*pyxj2;
        %computing pyx
        pyx = pyx.*pyxj;
    end
else
    pyx = one;
    for j = 1:M
        %sensor 1
        Y1 = Yt(2*j-1);
        pyxj1 = ( alpha1(j)*pdf(pf_type,Y1,pf_paramsa,pf_paramsb) + (1-alpha1(j))*gauss(0,sigobs1(j),( Y1*one-Ct(j,:) )') )';
        %sensor 2
        Y2 = Yt(2*j);
        pyxj2 =( alpha2(j)*pdf(pf_type,Y2,pf_paramsa,pf_paramsb) + (1-alpha2(j))*gauss(0,sigobs2(j),( Y2*one-Ct(j,:) )') )';
        % pyxj at location j: product of sensor 1 & sensor 2 pdfs
        pyxj = pyxj1.*pyxj2;
        %computing pyx
        pyx = pyx.*pyxj;
    end
end
%computing E
Evec = -log(pyx);
E = reshape(Evec,[nrows, ncols]); %??%h = fspecial('gaussian',3,0.5) ; %Efilt = filter2(h,E);E0=E; %E=Efilt;
%[Evec2,pyx2] = computeE(vtr,Yt,Chat,Br): needs a loop, will be very slow

% computing grad E
gradE = zeros(nrows,ncols,M-K);
[gradE(:,:,1),gradE(:,:,2)] = gradient(E,del); %:,:,1: indicates derivative wrt vr(1) ??

% computing grad of numerator of  D
gradD = zeros(nrows,ncols,M-K);
gradDvec = vtr - vrold*one ;
for p = 1: M-K
    gradD(:,:,p) = reshape(gradDvec(p,:),[nrows, ncols]); %places elements columnwise
end
% computing  grad of numerator of D numerically
% gradD = zeros(nrows,ncols,M-K);% Dvec = ( ( vtr - vrold*one ).^2 )/2;
% Dterm1 = reshape(Dvec(1,:),[nrows, ncols]);% Dterm2 = reshape(Dvec(2,:),[nrows, ncols]);
% [gradD(:,:,1),tmp] = gradient(Dterm1,del);% [tmp2,gradD(:,:,2)] = gradient(Dterm2,del);

%compute Hessian of E
[E11, E12] = gradient( squeeze(gradE(:,:,1)), del );
[E21, E22] = gradient( squeeze(gradE(:,:,2)), del );

% E convex region computation
det = E11.*E22 - E12.*E21;
Econvex = (det>=0)&(E11>=0); %all regions where E is convex

%0.01,0.01.0.005
epsdet = epsdetmult*max(abs(det(:)));
epsE11 = epsE11mult*max(abs(E11(:)));
epsL=epsLmult*max(max(max(abs(gradE))));
epsLs = epsL; %epsL small for computing value of Deltastar: bad idea: changes the min value a lot

Econvex = (det>=-epsdet)&(E11>=-epsE11); %modified defn of E convex

%compute R_KLC directly  % cannot compute R_LC since have not varied vs
VTR1 = reshape(vtr(1,:),[nrows, ncols]); %places elements columnwise
VTR2 = reshape(vtr(2,:),[nrows, ncols]);
dis1 = abs( VTR1 - vrold(1) ); min1=min(min(dis1));
dis2 = abs( VTR2 - vrold(2) ); min2=min(min(dis2));
[row_vrold, col_vrold] = find( (dis1==min1)&(dis2==min2) );
R_KLC = bwselect(Econvex,col_vrold,row_vrold);  %check if row counted downwards or upwards ??
if isempty(find(R_KLC))
    disp('[vs, vrold] does not belong to a locally convex region of E, breaking,setting Deltastar=-1')
    Deltastar=-1;
    return
    %    pause
end

%Compute  AKp
skipboundary = ones(size(R_KLC));
skipboundary([1,end],:)=0; skipboundary(:,[1,end])=0;

R_KLCc = (~R_KLC)&skipboundary;
D1=gradD(:,:,1); D2=gradD(:,:,2);
E1=gradE(:,:,1); E2=gradE(:,:,2);

AK1 = R_KLCc&(E1.*D1<0);
AK2 = R_KLCc&(E2.*D2<0);
ZK1 = R_KLCc&( (abs(E1)<epsL)&(E1.*D1>=0) );% );%    %(abs(D1)<epsL)|
ZK2 = R_KLCc&( (abs(E2)<epsL)&(E2.*D2>=0) );% );%    %(abs(D2)<epsL)|

%t1 = -D1(regionlocs)./E1(regionlocs); t2 = -D2(regionlocs)./E2(regionlocs);
region0 = AK1&AK2;
regionlocs = find(region0)';%if use (3:end-2,3:end-2) then change location numbers accordingly
t1 = abs(D1(regionlocs))./( epsLs + abs(E1(regionlocs)) );
t2 = abs(D2(regionlocs))./( epsLs + abs(E2(regionlocs)) );
Deltastar0 = min(max([t1;t2],[],1),[],2);

regionp = AK2&ZK1; %&(abs(E1)<epsL)
regionlocs = find(regionp)';
t2 = abs(D2(regionlocs))./( epsLs + abs(E2(regionlocs)) );
t1 = abs(D1(regionlocs))./( epsLs - abs(E1(regionlocs)) );
Deltastarp = min(max([t1;t2],[],1),[],2); %Deltastarp = min(t2)

regionpp = AK1&ZK2; %&(abs(E2)<epsL);
regionlocs = find(regionpp)';
t1 = abs(D1(regionlocs))./( epsLs + abs(E1(regionlocs)) );
t2 = abs(D2(regionlocs))./( epsLs - abs(E2(regionlocs)) );
Deltastarpp = min(max([t1;t2],[],1),[],2); %Deltastarpp = min(t1)

regionppp = ZK1&ZK2; %&(abs(E2)<epsL);
regionlocs = find(regionppp)';
t1 = abs(D1(regionlocs))./( epsLs + abs(E1(regionlocs)) );
t2 = abs(D2(regionlocs))./( epsLs - abs(E2(regionlocs)) );
Deltastarppp = min(max([t1;t2],[],1),[],2);


%Deltastar = min([inf,Deltastar0,Deltastarp,Deltastarpp]);
Deltastar = min([inf,Deltastar0,Deltastarp,Deltastarpp,Deltastarppp]);

disp(['epsL=',num2str(epsL,'%.2f'),' epsdet=',num2str(epsdet,'%.2f'),' epsE11=',num2str(epsE11,'%.2f')])
disp(['Deltastar0=',num2str(Deltastar0,'%.2f'),' Deltastarp=',num2str(Deltastarp,'%.2f'),' Deltastarpp=',num2str(Deltastarpp,'%.2f'),' Deltastarppp=',num2str(Deltastarppp,'%.2f')])
%disp(['Deltastar0=',num2str(Deltastar0,'%.2f'),' Deltastarp=',num2str(Deltastarp,'%.2f'),' Deltastarpp=',num2str(Deltastarpp,'%.2f')])
disp(['Deltastar= ',num2str(Deltastar,'%.2f')])

%********************************* Evaluating Results***********
% figure,imshow(R_KLC), hold on, plot(col_vrold,row_vrold,'b.')
%      %figure,imshow(Econvex), hold on, plot(col_vrold,row_vrold,'b.')
%
%
Dvec = ( ( vtr - vrold*one ).^2 )/2;
Dterm1 = reshape(Dvec(1,:),[nrows, ncols]);
Dterm2 = reshape(Dvec(2,:),[nrows, ncols]);
%
% gradL = gradE + gradD/Deltastar;
% L1=gradL(:,:,1); L2=gradL(:,:,2);
% %figure, contour(L1<=0,[0 0],'b'), hold on, contour(L2<=0,[0 0],'r'), grid minor
%
% mul=0.9; sig = (Deltastar*mul);
% Lunimod = E + Dterm1/sig + Dterm2/sig;
% [numextremaregions,extrematype,extrema,zc,eigvals,extremalocs,isminimum] =  findlocmins(Lunimod,del);
%     %disp(sprintf('number of nonzero isminimums= %d',length(find(isminimum)))), disp(sprintf('numextremaregions=%d',numextremaregions))
%     %%    [extrema,extremalocs] = findextrema(L,del,epsL)
%
% mul = 1.1; sig = (Deltastar*mul);
% Lmultimod = E + Dterm1/sig + Dterm2/sig;
% [numextremaregions,extrematype,extrema,zc,eigvals,extremalocs,isminimum] =  findlocmins(Lmultimod,del);
%     % disp(sprintf('number of nonzero isminimums= %d',length(find(isminimum)))), disp(sprintf('numextremaregions=%d',numextremaregions))
%     % %   [extrema,extremalocs] = findextrema(L,del,epsL)
%
%  figure,mesh(VTR1,VTR2, -E)
%     title('E(v_{t,r})')
%     xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'), zlabel('E')
%
%  figure,mesh(VTR1,VTR2, E)
%
% figure,  contour(VTR1,VTR2,E1,[0 0],'b'), hold on, contour(VTR1,VTR2,E2,[0 0],'r-+'), grid on
%     xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
%     legend('[\nablaE]_1=0','[\nablaE]_2=0','Location','BestOutside')
%     title('[\nablaE]_p=0, p=1,2')


%****************PLOT GRAPHS***************
%plotyn=1;
if plotyn
    close all,
    %direc='change_epsL'
    direc = 'temp'
    %   saveas(h,sprintf('roc_tc%d_r%d_totiter%d.fig',t0_abnorm,changerates(kk),totiter))
    datfname = [direc,'/dat']
    save(datfname,'Yt','Chat','Br','Bs','vrold','Ctold','vs','Deltastar','Deltastar0','Deltastarp','Deltastarpp','epsL','epsdet','epsE11')
    xaxis = VTR1(1,:); yaxis = VTR2(:,1)';
    xmin = min(xaxis); xmax = max(xaxis);
    ymin = min(yaxis); ymax = max(yaxis);

%     h=figure;
%     imshow(R_KLC,'Xdata',[xmin xmax],'Ydata',[ymin ymax]), axis on, hold on,
%     title('R_{K,LC} and the point v_{t-1,r}^i')
%     plot(xaxis(col_vrold),yaxis(row_vrold),'b.')
%     xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
%     saveas(h,[direc,'/RKLC.fig'])
% 
%     h=figure;
%     imshow(region0,'Xdata',[xmin xmax],'Ydata',[ymin ymax]), axis on, hold on,
%     title(['A_{K,1} \cap A_{K,2}, \Delta* = ',num2str(min([inf,Deltastar0]),'%.2f')] )
%     xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
%     saveas(h,[direc,'/AK1_AK2.fig'])
% 
%     h=figure;
%     imshow(regionp,'Xdata',[xmin xmax],'Ydata',[ymin ymax]), axis on, hold on,
%     title(['Z_{K,1} \cap A_{K,2}, \Delta* = ',num2str(min([inf,Deltastarp]),'%.2f')] )
%     xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
%     saveas(h,[direc,'/ZK1_AK2.fig'])
% 
% 
%     h=figure;
%     imshow(regionpp,'Xdata',[xmin xmax],'Ydata',[ymin ymax]), axis on, hold on,
%     title(['Z_{K,2} \cap A_{K,1}, \Delta* = ',num2str(min([inf,Deltastarpp]),'%.2f')] )
%     xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
%     saveas(h,[direc,'/ZK2_AK1.fig'])

% h=figure;
% imshow(regionppp,'Xdata',[xmin xmax],'Ydata',[ymin ymax]), axis on, hold on,
% title(['Z_{1} \cap Z_{2}, \Delta* = ',num2str(min([inf,Deltastarppp]),'%.2f')] )
% xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
% saveas(h,[direc,'/ZK2_ZK1.fig'])



    h=figure;  mesh(VTR1,VTR2, E)
    title('E(v_{t,r})')
    xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'), zlabel('E')
    saveas(h,[direc,'/E.fig'])

    h=figure; contour(VTR1,VTR2,E1,[0 0],'b'), hold on, contour(VTR1,VTR2,E2,[0 0],'r-+'), grid on
    xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
    legend('[\nablaE]_1=0','[\nablaE]_2=0','Location','BestOutside')
    title('[\nablaE]_p=0, p=1,2')
    saveas(h,[direc,'/nablaE.fig'])

    mul=0.9; sig = (Deltastar*mul);
    L = E + Dterm1/sig + Dterm2/sig;
    [L1,L2] = gradient(L,del);
    h=figure; contour(VTR1,VTR2,L1,[0 0],'b'), hold on, contour(VTR1,VTR2,L2,[0 0],'r-+'), grid on %minor
    xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
    title(['[\nablaL]_p=0, p=1,2 for \Delta = ',num2str(mul,'%.1f'),'\Delta* = ',num2str(sig,'%.2f')])
    legend('[\nablaL]_1=0','[\nablaL]_2=0','Location','BestOutside')
    saveas(h,[direc,'/nablaLunimod.fig'])

    h=figure;  mesh(VTR1,VTR2, L), title('L(v_{t,r})')
    xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'), zlabel('L')
    title(['L(v_{t,r}) for \Delta = ',num2str(mul,'%.1f'),'\Delta* = ',num2str(sig,'%.2f')])
    saveas(h,[direc,'/Lunimod.fig'])

    mul = 1.1; sig = (Deltastar*mul);
    L = E + Dterm1/sig + Dterm2/sig;
    [L1,L2] = gradient(L,del);
    h= figure; contour(VTR1,VTR2,L1,[0 0],'b'), hold on, contour(VTR1,VTR2,L2,[0 0],'r-+'), grid on %minor
    axis([xmin xmax ymin ymax])
    xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'),
    %    title(['\nablaL, \Delta = ',num2str(sig,'%.2f')])
    title(['[\nablaL]_p=0, p=1,2 for \Delta = ',num2str(mul,'%.1f'),'\Delta* = ',num2str(sig,'%.2f')])
    legend('[\nablaL]_1=0','[\nabla L]_2=0','Location','BestOutside')
    saveas(h,[direc,'/nablaLmultimod.fig'])

    h=figure;  mesh(VTR1,VTR2, L), title('L(v_{t,r})')
    xlabel('v_{t,r,1}'),  ylabel('v_{t,r,2}'), zlabel('L'),
    title(['L(v_{t,r}) for \Delta = ',num2str(mul,'%.1f'),'\Delta* = ',num2str(sig,'%.2f')])
    saveas(h,[direc,'/Lmultimod.fig'])

    h=figure;  mesh(VTR1,VTR2, -E), title('-E')


end


