%input to the Delta_star computation routine:
%variables: Yt, Chat (or Cold, vs), vrold
%parameters: Br, obs model

% in current version, vs is perfectly matched
% in a tracking algo, vs will have to be sampled, its value may decide
% which region of E we are in

del = 0.1/3;
vtr1vals = [-10: del : 10];
vtr2vals = [-15: del : 15];

%del = 0.01;
%vtr1vals = [-2: del : 2];
%vtr2vals = [-3: del : 3];

l1 = length(vtr1vals); l2 = length(vtr2vals);

[VTR1, VTR2] = meshgrid(vtr1vals,vtr2vals); %VTR1 varies along cols, VTR2 varies along rows
[nrows, ncols] = size(VTR1); %size returns rows * cols
vtr = zeros(M-K,l1*l2);
vtr(1,:) = reshape(VTR1,[1,ncols*nrows]); %takes elements columnwise from VR1
vtr(2,:) = reshape(VTR2,[1,ncols*nrows]);
%VTR1 = reshape(vtr(1,:),[nrows, ncols]); %places elements columnwise
%VTR2 = reshape(vtr(2,:),[nrows, ncols]);

% computation begins: uses only vtr from top
one = ones(1,ncols*nrows);
%computing pyx
Ct = Chat*one +  Br*vtr;
pyx = one;
for j = 1:M
    %sensor 1
    Y1 = Yt(2*j-1);
    pyxj1 = ( alpha1*pdf(pf_type,Y1,pf_paramsa,pf_paramsb) + (1-alpha1)*gauss(0,sigobs1,( Y1*one-Ct(j,:) )') )';
    %sensor 2
    Y2 = Yt(2*j);
    pyxj2 =( alpha2*pdf(pf_type,Y2,pf_paramsa,pf_paramsb) + (1-alpha2)*gauss(0,sigobs2,( Y2*one-Ct(j,:) )') )';
    % pyxj at location j: product of sensor 1 & sensor 2 pdfs
    pyxj = pyxj1.*pyxj2;
    %computing pyx
    pyx = pyx.*pyxj;
end
%computing E
Evec = -log(pyx);
E = reshape(Evec,[nrows, ncols]); %??
% computing grad E
gradE = zeros(nrows,ncols,M-K);
[gradE(:,:,1),gradE(:,:,2)] = gradient(E,del); %:,:,1: indicates derivative wrt vr(1) ??

%     % computing grad of numerator of  D
%     gradD = zeros(nrows,ncols,M-K);
%     gradDvec = vtr - vrold*one ;
%     for p = 1: M-K
%         gradD(:,:,p) = reshape(gradDvec(p,:),[nrows, ncols]); %places elements columnwise
%     end

% computing  grad of numerator of D numerically
gradD = zeros(nrows,ncols,M-K);
Dvec = ( ( vtr - vrold*one ).^2 )/2;
Dterm1 = reshape(Dvec(1,:),[nrows, ncols]);
Dterm2 = reshape(Dvec(2,:),[nrows, ncols]);
[gradD(:,:,1),tmp] = gradient(Dterm1,del);
[tmp2,gradD(:,:,2)] = gradient(Dterm2,del);

%compute Hessian of E
[E11, E12] = gradient( squeeze(gradE(:,:,1)), del );
[E21, E22] = gradient( squeeze(gradE(:,:,2)), del );

%compute R_KLC directly  % cannot compute R_LC since have not varied vs
det = E11.*E22 - E12.*E21;
Econvex = (det>=0)&(E11>=0); %all regions where E is  strictly convex??

epsdet = 0*0.001*max(abs(det(:)))
epsE11 = 0*0.001*max(abs(E11(:)))
Econvex = (det>=-epsdet)&(E11>=-eps);

VTR1 = reshape(vtr(1,:),[nrows, ncols]); %places elements columnwise
VTR2 = reshape(vtr(2,:),[nrows, ncols]);
dis1 = abs( VTR1 - vrold(1) ); min1=min(min(dis1));
dis2 = abs( VTR2 - vrold(2) ); min2=min(min(dis2));
[row_vrold, col_vrold] = find( (dis1==min1)&(dis2==min2) )
R_KLC = bwselect(Econvex,col_vrold,row_vrold);  %check if row counted downwards or upwards ??
if isempty(find(R_KLC))
    disp('[vs, vrold] does not belong to a locally convex region of E')
    pause
end

disp('check if [vs, vrold] is near the boundary of R_KLC')
disp('check if getting a tiny strip of non-convex region of E inside R_KLC')

%Compute BKp & AKp
R_KLCc = ~R_KLC;
BK = zeros(size(gradE));
AK = zeros(size(gradE));
for p = 1:M-K
    BK(:,:,p) = ( gradE(:,:,p).*gradD(:,:,p) ) < 0;
    AK(:,:,p) = BK(:,:,p)&R_KLCc;
end

%compute ratio
ratio = zeros(nrows,ncols,M-K);
ratio = - gradD./gradE ;

%compute Deltastar
region = squeeze( AK(:,:,1)&AK(:,:,2) );
for p = 1:M-K
    ratiop = ratio(:,:,p);
    %region = squeeze( AK(:,:,p) );
    regionlocs = find(region);
    Deltastar(p) = min([inf, min( ratiop(regionlocs) ) ]) ;
end
Deltastar

%********************************* Evaluating Results***********
D1=gradD(:,:,1);
D2=gradD(:,:,2);
E1=gradE(:,:,1);
E2=gradE(:,:,2);
%compute & display L
Dvec = ( ( vtr - vrold*one ).^2 )/2;
Dterm1 = reshape(Dvec(1,:),[nrows, ncols]);
Dterm2 = reshape(Dvec(2,:),[nrows, ncols]);
L = E + Dterm1/Sigr(1,1) + Dterm2/Sigr(2,2);

gradL = gradE + gradD/max(Deltastar);
L1=gradL(:,:,1); L2=gradL(:,:,2);
figure, contour(L1<=0,[0 0],'b'), hold on, contour(L2<=0,[0 0],'r'), grid minor


mul=0.5; sig = max(Deltastar*mul);
Lunimod = E + Dterm1/sig + Dterm2/sig;
[numextremaregions,extrematype,extrema] = findlocmins(Lunimod);
numextremaregions
%extrema

mul = 1.5; sig = max(Deltastar*mul);
Lmultimod = E + Dterm1/sig + Dterm2/sig;
[numextremaregions,extrematype,extrema] = findlocmins(Lmultimod);
%extrema
numextremaregions

figure,imshow(R_KLC), hold on, plot(col_vrold,row_vrold,'b.')

disp('if [vs vrold] is not near the boundary and if there is no tiny non-convex strip')
disp('then the true value of Deltastar is within 2-3 times the computed value')
disp('detect problem with non-convex strip by increasing epsdet, epsE11')
disp('detect problem of vrold near boundary by looking at its plot on R_KLC')

'***** there is also some code bug, sometimes finding a smaller value of Deltastar than needed'
'*** in current case, vs=-2.83, Yt = [-1.7962   -2.4526   -1.4314   -2.0055   -1.6466    0.6827]'
'**** getting a value of sig = 8204, have find(region) = r=199,c=1'

