%changed pf_parama and pf_paramb

%randn('state',0)
%rand('state',0)

%parameters: system
M=3; K=1;
% Bfull = eye(M,M);  %any orthonormal matrix
% Deltavec = [1, 0.5, 0.3];
% Deltafull = diag(Deltavec);

A = randn(M,M);
[eval,evec] = eigdec(A*A',M);
Bfull = evec;
Deltavec = eval;
Deltafull = diag(Deltavec);

Bs = Bfull(:,1:K);
Br = Bfull(:,K+1:M);

alldims = eye(M,M);
chooseKdims = alldims(:,1:K);
chooserestdims = alldims(:,K+1:M);
Sigs = chooseKdims'*Deltafull * chooseKdims;
Sigr = chooserestdims'*Deltafull * chooserestdims;
%parameters: obs model
alpha1 = 0.1;
alpha2 = 0.4;
sigobs1 = 1;
sigobs2 = 1;
pf_type = 'unif';pf_paramsa = -10; pf_paramsb = 10;

[alpha1,alpha2,sigobs1,sigobs2,pf_type,pf_paramsa,pf_paramsb]=getobsmodel(obsmodel);
[Bs,Br,Sigs,Sigr,As,Ar] = getsysmodel(sysmodel);
%alpha1 = 0.4*ones(M,1); 
%alpha2 = 0.1*ones(M,1); 
obsmodel = struct('alpha1',alpha1,'alpha2',alpha2,'sigobs1',sigobs1,'sigobs2',sigobs2,'pf_type',pf_type,'pf_paramsa',pf_paramsa,'pf_paramsb',pf_paramsb);
sysmodel = struct('Bs',Bs,'Br',Br,'Sigs',Sigs,'Sigr',Sigr,'As',As,'Ar',Ar);


%generate data
Cold = zeros(M,1);
vsold = zeros(K,1);
vrold = zeros(M-K,1);
vs = gsamp(vsold,Sigs,1)';
Chat = Cold + Bs*vs;
% hidden values, not available to any code
vr_true = gsamp(vrold,Sigr,1)';
Ct_true = Chat + Br*vr_true;


for j = 1:M
    coin = rand;
    if (coin < alpha1(j))
        Y1 = random(pf_type,pf_paramsa,pf_paramsb)
    else
        Y1 = gsamp(Ct_true(j),sigobs1(j),1)';
    end
    coin = rand;
    if (coin < alpha2(j))
        Y2 = random(pf_type,pf_paramsa,pf_paramsb) 
    else
        Y2 = gsamp(Ct_true(j),sigobs2(j),1)';
    end
    Y(2*j-1,1) = Y1;
    Y(2*j,1) = Y2;
    clear Y1, clear Y2
end








    
    

