%changed pf_parama and pf_paramb

%randn('state',0)
%rand('state',0)

%parameters: system
M=3; K=1;
Bfull = eye(M,M);  %any orthonormal matrix
Deltavec = [1, 0.5, 0.3];
Deltafull = diag(Deltavec);

A = randn(M,M);
[eval,evec] = eigdec(A*A',M);
Bfull = evec;
Deltavec = eval;
Deltafull = diag(Deltavec);

Bs = Bfull(:,1:K);
Br = Bfull(:,K+1:M);

alldims = eye(M,M);
chooseKdims = alldims(:,1:K);
chooserestdims = alldims(:,K+1:M);
Sigs = chooseKdims'*Deltafull * chooseKdims;
Sigr = chooserestdims'*Deltafull * chooserestdims;
%parameters: obs model
alpha1 = 0.1;
alpha2 = 0.4;
sigobs1 = 1;
sigobs2 = 1;
pf_type = 'unif';
pf_paramsa = -10;
pf_paramsb = 10;

%generate data
Cold = zeros(M,1);
vsold = zeros(K,1);
vrold = zeros(M-K,1);
vs = gsamp(vsold,Sigs,1)';
Chat = Cold + Bs*vs;
% hidden values, not available to any code
vr_true = gsamp(vrold,Sigr,1)';
Ct_true = Chat + Br*vr_true;


for j = 1:M
    coin = rand;
    if (coin < alpha1)
        Y1 = random(pf_type,pf_paramsa,pf_paramsb)
    else
        Y1 = gsamp(Ct_true(j),sigobs1,1)';
    end
    coin = rand;
    if (coin < alpha2)
        Y2 = random(pf_type,pf_paramsa,pf_paramsb) 
    else
        Y2 = gsamp(Ct_true(j),sigobs2,1)';
    end
    Yt(2*j-1,1) = Y1;
    Yt(2*j,1) = Y2;
    clear Y1, clear Y2
end








    
    

