%Noisy CS
%  disp('copying examples from Dantzig selector paper')
randn('state',0); rand('state',0); disp('random state 0 on')

m = 256;    n = 72;     S =  8; % round( n/log2(m/n) )
cc = 1; %10 %multiply 'sigma' and 'a' by 'cc'
lambdap = 4
sigma0 =  cc* (1/3)*sqrt(S/n)

for ct = 1:100
    Agen = (1/sqrt(n)) * randn(n,m);
    A = zeros(size(Agen));
    for col = 1:m
        A(:,col) = Agen(:,col)/norm( Agen(:,col) );
    end
    T0 = ceil( rand(S,1)*m );
    T = unique(T0);
    %    x = zeros(m,1); zeta = sign( rand(S,1) - 0.5 ); a = cc * randn(S,1); x(T) = zeta.*( sigma + 1 + abs(a) );

    %x(T)=cc : Maintain same SNR as far as x(T) is concerned, still increasing cc increases noise for other directions
    x = zeros(m,1);  x(T) = cc;
    y = A*x + sigma0*randn(n,1);

    %lin prog  %beta = 2; lambdap = sqrt( (1+beta)*2*log2(m) ); prob_lb = 1 - 1/( sqrt(pi*log2(m))*m^beta )
    del = lambdap * sigma0 ;
    c = [zeros(m,1);
        ones(m,1)];
    F = [eye(m,m)  , -eye(m,m) ;
        -eye(m,m) , -eye(m,m) ;
        A'*A      , zeros(m,m);
        -A'*A     , zeros(m,m);       %-A'A*x < =
        zeros(m,m), -eye(m,m) ]  ;    %u >= 0
    b = [zeros(m,1);
        zeros(m,1);
        del + A'*y;
        del - A'*y;
        zeros(m,1)];
    sigma = sigma0; % noisy CS
    % sigma = 0 ; %run CS for no noise case: assume small noise is actually the "compressible" part of a compr. signal x.

    if sigma>0
        [xfullhat,fval,exitflag,output,lambda] = linprog(c,F,b);
    else
        %disp('not noisy CS')
        F_exact = [eye(m,m)  , -eye(m,m) ;
            -eye(m,m) , -eye(m,m) ;
            zeros(m,m), -eye(m,m) ];
        b_exact = [zeros(m,1);
            zeros(m,1);
            zeros(m,1)];
        F_eq_exact = [A, zeros(n,m)];
        b_eq_exact = y;
        [xfullhat,fval,exitflag,output,lambda] = linprog(c,F_exact,b_exact,F_eq_exact,b_eq_exact);
    end

    xhat = xfullhat(1:m);
    uhat = xfullhat(m+1:end);
    if sigma > 0
        alpha = (0.5/4)*lambdap; %0.5
    else
        alpha = (3/4)*lambdap;
    end
    T_hat = find(abs(xhat) > alpha * sigma0);
    AT_hat = A(:,T_hat);
    xhat_ls_T_hat = inv(AT_hat'*AT_hat) * AT_hat'*y;
    xhat_ls = zeros(size(x));
    xhat_ls(T_hat) = xhat_ls_T_hat;

    disp(sort(T)'), disp(T_hat'), %disp(sigma)
    %disp(norm(x-xhat) ),  disp(norm(x-xhat_ls) ),
    ratio_ls(ct) =  norm(x-xhat_ls) / norm(x);
    ratio(ct) =  norm(x-xhat) / norm(x);

    not_detected(ct) = length( setdiff(T,T_hat) );
    extra_detected(ct) = length( setdiff(T_hat,T) );

    %ratio w.r.t. ideal LS estimator (assumes the set T is known)
    AT = A(:,T);
    xhat_ideal = zeros(size(x));
    xhat_ideal(T) =  inv(AT'*AT) * AT'*y;
    err_ideal = norm(x-xhat_ideal);
    err_ideal_I = sum( min( x.^2 , (sigma^2)*ones(size(x)) ) );
    ratio_ideal(ct) = err_ideal / norm(x);
    % pause(0.1), beep
end
