function [x_upd,T_hat,x_upd_csres] = kfcs_full(y,Pi0,A,Q,R)
global n
global m
global tot
global lambdap
global S
global Smax

% T_hat_t{t} = LSCS estimate of nonzero set at t
% x_upd(:,t) = x_hat at t
% Q1 = system noise covariance computed using current T_hat
% max_add: maximum number of additions allowed: ensure A(:,T_hat) remains full rank
% thresh: addition threshold
% thresh_del: deletion threshold
% k



sigma0 = sqrt(R(1,1));
sig2sys = Q(1,1);
sig2init = Pi0(1,1)*3
thresh_init = (3/4)*lambdap * sigma0; %3*
thresh = 3*(1/4)*lambdap * sigma0; % 3*
thresh_del = thresh/3;
thresh_Pupd = 0.05*sigma0^2;
k = 3; %duration to average x_upd to check for deletion
%To Do: try smoothing estimates.

x_upd = zeros(m,tot);
xupd = zeros(m,1); xupd_tmp = zeros(m,1);
xupd2 = zeros(m,1); xupd_tmp2 = zeros(m,1);


P_pred = zeros(m,m);
P_upd = zeros(m,m);
Q1 = zeros(m,m);
t=1;

max_add = ceil( (1.25/2)*n/log2(m));  %1.25*n/log2(m) %Smax/2 %1.25*Smax;
max_add_init = ceil(max_add*3/2)

%T_hat = T1; S_hat = length(T_hat);

%t=1: CS followed by LS
%Initial CS: Running No-Noise-CS here: better when doing Regular CS
[x_hat_ls, x_hat,T_hat_tmp] = cs_solve(y(:,t),A,0,sigma0,lambdap,thresh_init); %change alpha
T_hat = find(abs(x_hat) > thresh_init);
% prevent too many extra additions
if length(T_hat) > max_add_init
    disp('more than max_add directions detected'),
    [val,indx] = sort(abs(x_hat)); %(T_hat)
    T_hat=indx(end:-1:end-max_add_init+1);
end
A_T = A(:,T_hat);
xupd(T_hat,1) = A_T \ y(:,t);
xupd2(T_hat,1) = inv(A_T'*A_T)*A_T'*y(:,t); %xpred + K*(y(:,t) - A*xpred);
x_upd(:,t) = xupd;
T_hat_t{t} = T_hat;

for t = 2 : tot %t2   %
    % Temporary LS
    T_hat_old = T_hat_t{t-1};
    A_T =  A(:,T_hat_old);
    xupd_tmp(T_hat_old,1) =  A_T \ y(:,t);
    %xupd_tmp2(T_hat_old,1) = inv(A_T'*A_T)*A_T'*y(:,t);  %x_upd(:,t-1) + K*(y(:,t) - A*x_upd(:,t-1));

    % Compute filtering error (FE), FEN
    y_fe =  y(:,t) - A*xupd_tmp;    %Sigma_fe = (eye(n) - A*K)*(A*P_pred_tmp*A' + R)*(eye(n) - A*K)';
    fe(t) = y_fe'*y_fe/n; %*inv(Sigma_fe)

    %CS on FE
    if fe(t) > 0 %2 %1.25 %
        [betahat_ls_tmp,beta_hat,T_hat_tmp] = cs_solve(y_fe,A,1,sigma0,lambdap,thresh); %change alpha
        T_hat_c = setdiff([1:m]',T_hat);
        Tdiff_hat = intersect(T_hat_c, find(abs(beta_hat) > thresh) );%Sdiff_hat = length(Tdiff_hat);
        
        %preventing too many additions: to ensure A(:,T_hat) remains full rank
        %         if length(Tdiff_hat) > max_add, %1.25*
        %             Tdiff_hat0 = Tdiff_hat;
        %             disp('more than max_add directions detected'),
        %             [val,indx] = sort(abs(beta_hat));
        %             Tdiff_hat=indx(end:-1:end-max_add+1);
        %         end
        T_hat_1 = [T_hat; Tdiff_hat];
        A_T_hat_1 = A(:,T_hat_1);
        len = length(Tdiff_hat);
        if (len > max_add) | (rank(A_T_hat_1) < length(T_hat_1))
            totadd = min(len,max_add);
            Tdiff_hat0 = Tdiff_hat;
            [val,indx] = sort(abs(beta_hat));
            Tdiff_hat=indx(end:-1:end-totadd+1);
            T_hat_1 = [T_hat; Tdiff_hat];
            A_T_hat_1 = A(:,T_hat_1);
            while rank(A_T_hat_1) < length(T_hat_1)
                disp('A_T_hat_1 is not full rank')
                Tdiff_hat = Tdiff_hat(1:end-1);
                T_hat_1 = [T_hat; Tdiff_hat];
                A_T_hat_1 = A(:,T_hat_1);
            end
        end
        T_hat = [T_hat; Tdiff_hat];

        x_upd_csres(:,t) = beta_hat + xupd_tmp;
    end
    % Final LS
    A_T= A(:,T_hat);
    xupd(T_hat,1) = A_T \ y(:,t);
    %xupd2(T_hat,1) = inv(A_T'*A_T)*A_T'*y(:,t); %xpred + K*(y(:,t) - A*xpred);

    x_upd(:,t) = xupd;
    T_hat_t{t} = T_hat;

    % %Temporarily commented the deletion step
    %     %COEFFICIENT REMOVAL: do it only if KF stabilized,
    %         %BETTER WAY: before removing check to make sure x_upd still "constant". If it is not => make a mistake earlier: put it back into the NZ set.
    %     if (t>5)&(isequal(T_hat_t{t},T_hat_t{t-1},T_hat_t{t-2},T_hat_t{t-3},T_hat_t{t-4}))
    %         tmp = find( (abs(x_upd(:,t))  < thresh_del)&(abs(x_upd(:,t-1))  < thresh_del) &(abs(x_upd(:,t-2))  < thresh_del) );
    %         %tmp= find( (mean(abs(x_upd(:,t-k+1:t)),2) < thresh_del) );
    %         Delta_c = intersect(T_hat, tmp );
    %         T_hat = setdiff(T_hat, Delta_c);
    %         T_hat_t{t} = T_hat;
    %          %T_hat_c = setdiff([1:m]',T_hat); tmp2 = find(diag(P_upd) < thresh_Pupd);
    %     end
end

%disp('change: Delta_r = Delta_c')

%if (t>4)&(isequal(T_hat_t{t},T_hat_t{t-1}))&(isequal(T_hat_t{t-1},T_hat_t{t-2}))&(isequal(T_hat_t{t-2},T_hat_t{t-3}))&(isequal(T_hat_t{t-3},T_hat_t{t-4}))

% ICIP CS-FE step
%       A_rest = A(:,T_rest);T_rest = setdiff([1:m]',T_hat);
%       [x_rest_hat_ls, x_rest_hat,T_rest_hat] = cs_solve(y_rest,A_rest,1,sigma0,lambdap,thresh); %change alpha%
%         if length(T_rest_hat) > S %S_hat
%             disp('more than S new directions detected') %keyboard
%             [val,indx] = sort(abs(x_rest_hat_ls));
%             T_rest_hat=indx(end:-1:end-S+1); %indx(end-S_hat+1:end); %
%         end
%         Tdiff_hat = T_rest(T_rest_hat);    Sdiff_hat = length(Tdiff_hat);


