%Tt{t}: True nonzero set at time t
%T_hat_t{t} (used in kfcs_full.m): estimated nonzero set at t
%Smax: S_{max}

global Smax

x = zeros(m,tot);
y = zeros(n,tot);

sig2sys = Q(1,1);
sig2init = Pi0(1,1);

t = 1;

%generating initial nonzero set
St{t} = 8;
tmp = unique(ceil( rand(St{t},1)*m ));
while length(tmp) < St{t}
    tmp = unique(ceil( rand(St{t},1)*m ));
end
Tt{t} = tmp;

%defining the number of additions at each t and adding them
for t = 2:tot
%defining the number of additions at t
    if ( (t<=50)&(t>=10)&(mod(t,5)==0) )
     Sdiff{t} = 2;
%     if (t==10)
%         Sdiff{t} = 4;
%     elseif (t==20)
%         %Sdiff{t} = -3;
%         Sdiff{t} = 4;
%     elseif (t==30)
%         Sdiff{t} = 4;
        %elseif ( (t<=51)&(t>=30)&(mod(t,3)==0) )
        %   Sdiff{t} = +2;
     else
        Sdiff{t} = 0;
    end
    St{t} = St{t-1} + Sdiff{t};

    %adding new additions at t: make sure all elements unique
    if   Sdiff{t}==0
        Tt{t} = Tt{t-1};
    elseif  Sdiff{t} > 0
        tmp = unique(ceil( rand(Sdiff{t},1) * (m - St{t-1}) ));
        while length(tmp) < Sdiff{t}
            tmp = unique(ceil( rand(Sdiff{t},1) * (m - St{t-1}) ));
        end
        T_old_c = setdiff([1:m]',Tt{t-1});
        Tdiff = T_old_c(tmp);
        Tt{t} = union(Tt{t-1},Tdiff);
    else
        tmp = unique(ceil( rand(abs(Sdiff{t}),1) * (St{t-1}) ));
        while length(tmp) < abs(Sdiff{t})
            tmp = unique(ceil( rand(abs(Sdiff{t}),1) * (St{t-1}) ));
        end
        Tdiff = Tt{t-1}(tmp);
        Tt{t} = setdiff(Tt{t-1},Tdiff);
    end
end

%simulating the signal sequence and the observations
t=1;
Q1 = zeros(m,m);
diffset = Tt{t};
commonset = [];
Q1(diffset,diffset) = sig2init*eye(length(diffset));
Q1(commonset,commonset) = sig2sys*eye(length(commonset));
x(:,t) = sqrt(Q1)*randn(m,1); % change sqrt for Q1 non-diagonal
y(:,t) = A*x(:,t) + sqrtm(R)*randn(n,1);

for t = 2 : tot
    Q1 = zeros(m,m);
    diffset = setdiff(Tt{t},Tt{t-1});
    commonset = intersect(Tt{t},Tt{t-1});
    Q1(diffset,diffset) = sig2init*eye(length(diffset));
    Q1(commonset,commonset) = sig2sys*eye(length(commonset));

    x(:,t) = x(:,t-1) + sqrt(Q1)*randn(m,1);% change sqrt for Q1 non-diagonal
    y(:,t) = A*x(:,t) + sqrtm(R)*randn(n,1);
end

Smax = max(cell2mat(St));

