for ct = 1:1
  clear all
  %  disp('copying examples from Dantzig selector paper')
   % randn('state',0); rand('state',0); disp('random state 0 on')
    m = 256;
    n = 72;
    S =  8 % round( n/log2(m/n) )
    cc = 10 %multiply 'sigma' and 'a' by 'cc'
    
    sigma =  cc* (1/3)*sqrt(S/n)
    Agen = (1/sqrt(n)) * randn(n,m);
    A = zeros(size(Agen));
    for col = 1:m
        A(:,col) = Agen(:,col)/norm( Agen(:,col) );
    end
    T = ceil( rand(S,1)*m );

    x = zeros(m,1);
    zeta = sign( rand(S,1) - 0.5 ); if length( find(zeta) ) < S,  keyboard, end
    a = cc * randn(S,1);
    x(T) = zeta.*( sigma + 1 + abs(a) );

    y = A*x + sigma*randn(n,1);

    %lin prog

    %beta = 2; lambdap = sqrt( (1+beta)*2*log2(m) ); prob_lb = 1 - 1/( sqrt(pi*log2(m))*m^beta )
    lambdap = 4
    del = lambdap * sigma ;
    c = [zeros(m,1);
        ones(m,1)];
    F = [eye(m,m)  , -eye(m,m) ;
        -eye(m,m) , -eye(m,m) ;
        A'*A      , zeros(m,m);
        -A'*A     , zeros(m,m);       %-A'A*x < =
        zeros(m,m), -eye(m,m) ]  ;    %u >= 0

    b = [zeros(m,1);
        zeros(m,1);
        del + A'*y;
        del - A'*y;
        zeros(m,1)];

    if sigma>0
        [xfullhat,fval,exitflag,output,lambda] = linprog(c,F,b);
    else
        F_exact = [eye(m,m)  , -eye(m,m) ;
                   -eye(m,m) , -eye(m,m) ;  
                   zeros(m,m), -eye(m,m) ];
        b_exact = [zeros(m,1);
                   zeros(m,1);
                   zeros(m,1)];               
        F_eq_exact = [A, zeros(n,m)];
        b_eq_exact = y;
        [xfullhat,fval,exitflag,output,lambda] = linprog(c,F_exact,b_exact,F_eq_exact,b_eq_exact);
    end

    xhat = xfullhat(1:m);
    uhat = xfullhat(m+1:end);

    alpha = 0.5
    T_hat = find(abs(xhat) > alpha * sigma);
    AT_hat = A(:,T_hat);
    xhat_ls_T_hat = inv(AT_hat'*AT_hat) * AT_hat'*y;
    xhat_ls = zeros(size(x));
    xhat_ls(T_hat) = xhat_ls_T_hat;

 disp(sort(T)'), disp(T_hat')
disp(norm(x-xhat) ),  disp(norm(x-xhat_ls) ), 
ratio =  norm(x-xhat_ls) / norm(x)

%ratio w.r.t. ideal LS estimator (assumes the set T is known)
AT = A(:,T);
xhat_ideal = zeros(size(x));
xhat_ideal(T) =  inv(AT'*AT) * AT'*y;
err_ideal = norm(x-xhat_ideal)
err_ideal_I = sum( min( x.^2 , (sigma^2)*ones(size(x)) ) )

% pause(0.1), beep
end