
%given an image I, with a curve in it,
%we find the coords of this curve by tracing it 
%in a sequential manner and returning finally to the
%starting point


function [x_co,y_co] = trace_curve(I)


[nx,ny] = size(I);
J = I;

%we assume that the curve is not rotated and hence
%the first non-zero entry in x direction (matlab x direction)
%is always similar in each of the curves

%we are using a mask [1 1 1
%                     1 1 1];
%to trace the curve and we flip this mask by 180 degrees when
%we want to go in the opposite direction

[sx,sy]  = find(I~=0);
for i=1:nx
    tmp = find(I(i,:)~=0); 
    if(~isempty(tmp))
        start_y = tmp(1); %find the first non-zero entry in x direction
        start_x = i; %this is our starting point
        break;
    end
end

mask = [1 1 1;1 1 1];
new_x = 1; %just a dummy we use so that we can test whether we reached the starting point or not
new_y = 1;
x = start_x; %actual starting point
y = start_y;
mask_flipped = 0; %start with the normal mask

x_co = [1 x];
y_co = [1 y];
ct = 1;

I(x,y) = 0;

not_found = 0;
ct_flipped = 0;
back_here = 0;
iter = 0;

while(back_here == 0)
 
 %if we reached the starting point
 if(((start_x == new_x)&(start_y == new_y))|(iter == 3000))
   back_here = 1;
   break;
 end
 
 iter = iter+1; %number of times we are iterating to find the curve
 %region around the center where we will see if we have a non-zero entry
 x_off = 3; 
 y_off = 2;
 
 %mask is not flipped
 if(~mask_flipped)
     anded_result = mask & I(x:x+1,y-1:y+1); %check for non-zero entry
     not_found = 0;
     
     %check for each of the places where the mask can be non-zero
     %the order in which we check is important. so dont change that !
     if(anded_result(2,2) == 1)
         y = y;
         x = x+1;
         %make sure we are not duplicating the entries
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1; %we found a point with non-zero entry
            I(x,y) = 0; %make this point zero in the image, so that we dont detect it twice !
            continue;
        else
            x = x-1; %if we had duplicate entries
            not_found=0; %we found nothing here
        end
        
     end
     
     if(anded_result(2,3) == 1)
         y = y+1;
         x = x+1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y-1;
            x = x-1;
            not_found=0;
        end
     end
     
     if(anded_result(1,3) == 1)
         y = y+1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y-1;
            not_found=0;
        end
        
     end
     
     
     if(anded_result(1,1) == 1)
         y = y-1;
         
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y+1;
            not_found=0;
        end
         
     end
     
     
     if(anded_result(2,1) == 1)
         y = y-1;
         x = x+1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y+1;
            x = x-1;
            not_found=0;
        end
     
     end
     
     
     if(not_found == 0) %we didnt find anything in the mask,so check the next line
         if((x+x_off)>nx) 
            x_off = 2;
            if((x+x_off)>nx)
               x_off = 1;
            end
         end
         if(((y-y_off)<1) | (y+y_off>ny))
            y_off = 1;
            if(((y-y_off)<1) | (y+y_off>ny))
                y_off=0;
            end
         end
         if(~isempty(find(I(x:x+x_off,y-y_off:y+y_off)~=0)))
             [xt,yt] = find(I(x:x+x_off,y-y_off:y+y_off)~=0);
             x = x+xt(1);
             if(yt(1)<=2)
               y = y-yt(1);
             else
               y = (yt(1)-3)+y;
             end
             if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
                new_y = y;
                new_x = x;
                x_co = [x_co new_x];
                y_co = [y_co new_y];
                I(x,y) = 0;
            end
         else
             mask_flipped = 1;
             ct_flipped = ct_flipped + 1;
         end
     end
     
     
     
 else  %end if not mask flipped
 
     %if the mask is flipped
 
    anded_result = mask & I(x-1:x,y-1:y+1);
     not_found = 0;
     
     %once again do the same this as was done above but with mask reveresed
     if(anded_result(1,2) == 1)
         y = y;
         x = x-1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            x = x+1;
            not_found=0;
        end
     end 
     
     if(anded_result(1,3) == 1)
         y = y+1;
         x=x-1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y-1;
            x=x+1;
            not_found=0;
        end
     end 
     
     if(anded_result(1,1) == 1)
         y = y-1;
         x= x -1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y+1;
            x=x+1;
            not_found=0;
        end
     end
     
     
    
     if(anded_result(2,1) == 1)
         y = y-1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y+1;
            not_found=0;
        end
     end 
     
     
     if(anded_result(2,3) == 1)
         y = y+1;
         if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
            new_y = y;
            new_x = x;
            x_co = [x_co x];
            y_co = [y_co y];
            not_found = 1;
            I(x,y) = 0;
            continue;
        else
            y = y-1;
            not_found=0;
        end
     end 
     
     if(not_found == 0) %we didnt find anything in the mask
         %make sure we dont exceed the image boundaries
        if((x-x_off)<1) 
            x_off = 2;
            if((x-x_off)<1) 
               x_off = 1;
            end
        end
        if(((y-y_off)<1) | (y+y_off>ny))
            y_off = 1;
            if(((y-y_off)<1) | (y+y_off>ny))
               y_off = 0;
            end
        end
         %what if we have more than one entry as non-zero
         if(~isempty(find(I(x-x_off:x,y-y_off:y+y_off)~=0)))
             [xt,yt] = find(I(x-x_off:x,y-y_off:y+y_off)~=0);
             x = x-(4-xt(end));
             if(yt(1)<=2)
               y = y-yt(1);
             else
               y = (yt(1)-3)+y;
             end
             
             if(((x_co(end) ~= x) | (y_co(end) ~= y)) & ((x_co(end-1) ~= x) | (y_co(end-1) ~= y)))
                new_y = y;
                new_x = x;
                x_co = [x_co new_x];
                y_co = [y_co new_y];
                I(x,y) = 0;
             end
         else
             mask_flipped = 0;
             ct_flipped = ct_flipped + 1;     
         end
     end
     
     
 end %mask

 %we probabably flipped the mask a number of times and should break now
 if(ct_flipped >= 50)
        %fprintf('we have flipped the mask many times now, so break\n');
        back_here = 1;
        break;
  end    
    
 
end %while

%figure(3), imshow(I);
%figure(4), imshow(J);

 