I_int = double(imread('..\\moving_car\\red_car_331_int.png'));
I_ext = double(imread('..\\moving_car\\red_car_331_ext.png'));

frame0 = double(imread('..\\moving_car\\red_car_00000331.png'));

frame0 = (imresize(frame0,0.25,'bilinear'));
I_ext = (imresize(I_ext,0.25,'bilinear'));
I_int = (imresize(I_int,0.25,'bilinear'));

%generate signed distance function
dmap_int = bwdist(I_int);
dmap_ext = -bwdist(I_ext);
level_set = dmap_int + dmap_ext;
[nx,ny] = size(level_set);

imno = 356
name = '..\\moving_car\\red_car_00000'; %which sequence to generate samples for
postfix  = 'png';
fname = sprintf('%s%d.%s',name,imno,postfix);
im = imresize(double(imread(fname)),0.25);

%stopping term
nO = 1;
phi_aff = im;
SmthI = [phi_aff(nO:-1:1,nO:-1:1) phi_aff(nO:-1:1,:) phi_aff(nO:-1:1,end:-1:end-nO+1); ...
    phi_aff(:,nO:-1:1) phi_aff phi_aff(:,end:-1:end-nO+1); ...
    phi_aff(end:-1:end-nO+1,nO:-1:1) phi_aff(end:-1:end-nO+1,:) phi_aff(end:-1:end-nO+1,end:-1:end-nO+1)];
I_y = (SmthI(2:end-1,3:end)-SmthI(2:end-1,1:end-2))/2;
I_x = (SmthI(3:end,2:end-1)-SmthI(1:end-2,2:end-1))/2;
stop_term = 1 ./(1 + I_x.^2 + I_y.^2);
clear I_x;
clear I_y;

lset = level_set;
% get narrow band first time
[xco,yco] = find(abs(lset)<=1.5); %one pixel away from zero level set
int_indx = find(abs(lset)<=1.5);
indx = find(abs(lset)>1.5 & (abs(lset<2.9))); %boundary pixels
status_set = 2*ones(nx,ny);% 2 , in the far area
status_set(int_indx) = 1; %in the narrow band
status_set(indx) = 0; %we are on boundary
nbsz = length(xco);

count = 0;
u_prev = 0;

% gives new narrow band  w.r.t. current zero level set - width is 6
[xco,yco,zeroset,xc,yc,lset,status_set,nbset] = Find_Narrow_band(lset,status_set,xco,yco,1);
for iter = 1 : 120
    [lset,u,v,dt] = Narrow_Evolve0(lset,im,stop_term,1,1,0,xco,yco,status_set,zeroset);
    lset = re_distance(lset,10);
    [xco,yco,zeroset,xc,yc,lset,status_set,nbset] = Find_Narrow_band(lset,status_set,xco,yco,1);
    %To DO: set expand = 0 (last input variable above), to not find NB at every iteration

    curve = zeros(nx,ny);
    curve(zeroset) = 1;
    curr_lset = lset;

    if(abs(u_prev -u)<=0.7)
        count = count + 1;
    else
        count = 0;
    end
    u_prev = u;
    if (count==10)
        disp('mean intensity stabilized, breaking')
        disp(iter)
        break
    end

    % Display
    t = im;
    xm = round(mean(xco));
    ym = round(mean(yco));
    t(xm,ym) = 255;
    t(zeroset) = 255;
    E = (u-v)^2;
    E2 = mean2( ( (im(lset<0)-u).^2 ).*( 1./(1+im(lset<0).^2) ) );
   disp(sprintf('dt = %f, u = %f, v = %f, E = %f, E2 = %f \n',dt,u,v,E,E2));
    figure(2), contour(lset,[0 0], 'b');
    %figure(1), imshow(uint8(abs(lset)));
    figure(3), imshow(uint8(t));

end

