%For any new sequence, need to set u0,v0,u2 and change initialize.m
% Also see learn_geom for learning the system model parameters

%Running Algorithm 1 of cdc paper: deform =1, translate=1, tdim = 2
%Running [18] (cvpr05)'s algorithm:  deform = 0, translate=1, tdim = 6

global n py_thresh
global K K0
global alpha
global deform Sigma0 A Signoise signoise a
global u0 v0 u2
global sig2obs  sig2curve
global dmax rho alpha sig2obsedge subsamplerate edgemin edgemax
global eps gamma
global translate Sigma0_trans Signoise_trans signoise_trans atrans tdim
global Kt dmin2 dmax2 dopt order
global sz energyscale
global zerolength changetopo atbndry setzero  knotschange  toofewknots %knotsclose
global  knotschangem changetopom atbndrym zerolengthm fixedK Ktsim useKtsim
global impsampling impsampiters
global nomarkov resampinterval
global bias0 bias deformindx biasvec
global dispyn dispsamps
global eigvecs usingeigvecs
usingeigvecs =0;

% when low contrast between the intensities => large error in edge location: increase sig2obsedge
v0 = 40;  %background
u0 = 85; %120; %85  %object 1
u2 = 130; %200; %130; %120;  % object 2

% Observation model parameters
sig2obs =  10^2; %3^2 ;
sig2curve = 2*sig2obs; %0.75^2
sig2obsedge = 1; % if reduced constrast, increase this
dmax = 3*sqrt(sig2obsedge);   % max window size to search for edge
rho = 10*sqrt(sig2obsedge);   % location of a missed edge, increase this value to stick to one hypothesis
edgemin = 2;
edgemax = 3;
alpha = 0.1; % probability of clutter producing an edge, not being used
subsamplerate = 5;
%u0 =  60; % 10;
%v0  = 180;   %45;

n = 1; % set n in mcpf2_geom again.

%PF parameters    %eps = 1e-20; gamma = 1e4
resampinterval = 1;   %resample every so many frames
py_thresh = 1e-350; %py_thresh = 1e-50;
impsampling = 0;    % set again in mcpf2_geom
impsampiters = 2;   % number of GD iterations
alpha = 0.1;  % weight given to kappa term %'motion due to kappa not being incorporated when moving the knots';

% System Model parameters
K = 6;
K0 = K;
fixedK = 1;    % use the same K for all particles
useKtsim = 0;  
nomarkov = 0;  % use Markov model     %when using Markov vel, set signoise to a small value

%being changed in runsims.m
%translate = 1; % generate translation/affine deformation samples
%tdim = 6      %tdim=2, generates only translation samples, tdim=6 generates affine deformation samples
%deform = 0     % generate local deformation samples

a = 0.5;       % A = a*eye(K) : set in mcsystemsample2.m
atrans = 0;
Sigma0_trans = 0.5^2 *eye(tdim) ;
signoise_trans =  [0.00025*5^2*[1 1 1 1],  0.25*[1 1]]   %signoise_trans = [0.0025*[1 1 1 1], 0*[1 1]];
Sigma0 =  (1/2)^2 *eye(K); %good for simulation  %car sequence, used:  %4 * eye(K) ;
signoise = 0.25 *4;  %


% B-spline basis order and parameters to change K
order = 3; %B-spline basis order: when moving knotloc j : 2 regions before it and one after it get affected
% eg if v_j, j=3 is only non-zero then the region b/w knots 1&2, 2& 3 and 3&4 gets moved
dmin2 = 10^2;    %= \Delta_{max}^2  (from CDC paper)
dmax2 = 60^2; %45^2; %25^2   %= \Delta_{min}^2 (from CDC paper)
dopt = 35; %25; %30          %= \Delta_{opt}   (from CDC paper)p

% For simulation sequence
bias0 = 1 * 6 % set bias = bias0 only while simulating the sequence.
bias = 0; % used in PF, but bias0 used to increase variance of the deformindx knot
deformindx = [K]; %[8] 
 
% display, saving etc
dispyn= 0;
saveyn= 0;
dispsamps = 0;

% 2 object classes
global M objectclass deformindxmt objecttype
objecttype = 1;   % described in README.tex

M = 1;  %M=2 to track two objects with objectclass specified below
objectclass(1) =  objecttype
objectclass(2) = 2;
global thetaknots     % the knot locations for theta
thetaknots = [0:2*pi/K:2*pi*(K-1)/K] ;
