% TRYING contour motion by defining basis velocities
% WORKS: makes closed curves with n0 vertices and of order k0
% parameter p varies from 0 to 1 on the useful part of the curve

n0 = 4
k0 = 3

n = n0 + k0 - 1
pi = zeros(n+k0,1);

%pi(1:n+k0,1) = [1:n+k0]';
%p = [pi(1):0.1:pi(n+k0)]';

%pi(k0) = 0;   %k0=2,n+1=5
%pi(n+1) = 1;   %k0=3,n+1=6

pi(k0:n+1,1) = [0:1/(n0):1]';
pi(1:k0-1,1) = [-(k0-1)/(n0): 1/(n0) : -1/(n0) ]';
pi(n+2:n+k0) = [1+1/(n0): 1/(n0) : 1 + (k0-1)/(n0) ]';

%p = [pi(k0):0.01:pi(n+1)]';
p = [0:0.0001:1]';

pcorrect_index = find( (p>=pi(k0)) & (p<=pi(n+1)) );
pcorrect = p(pcorrect_index);

picorrect_index = find( (pi>=pi(k0)) & (pi<=pi(n+1)) );
picorrect = pi(picorrect_index);

pi_index = find(ismember(p,pi));

basis = coxdeboor3(k0,n,pi,p,k0);


randn('state',0); 
C_basis_x = randn(n0,1);
C_basis_y = randn(n0,1);
C_basis_x(n0+1:n) = C_basis_x(1:k0-1);
C_basis_y(n0+1:n) = C_basis_y(1:k0-1);

C_full_x = basis*C_basis_x;
C_full_y = basis*C_basis_y;

C_x = C_full_x(pcorrect_index);
C_y = C_full_y(pcorrect_index);

hold on
plot(C_basis_x,C_basis_y,'r-o')
plot(C_x,C_y)

%keyboard

Cdot_basis_x = randn(n0,1)/5;
Cdot_basis_y = randn(n0,1)/5;
Cdot_basis_x(n0+1:n) = Cdot_basis_x(1:k0-1);
Cdot_basis_y(n0+1:n) = Cdot_basis_y(1:k0-1);

Cdot_full_x = basis*Cdot_basis_x;
Cdot_full_y = basis*Cdot_basis_y;
Cdot_x = Cdot_full_x(pcorrect_index);
Cdot_y = Cdot_full_y(pcorrect_index);


Cnew_x = C_x + Cdot_x;
Cnew_y = C_y + Cdot_y;
%plot(Cnew_x,Cnew_y,'g-o')
Cnew_basis_x = C_basis_x + Cdot_basis_x;
Cnew_basis_y = C_basis_y + Cdot_basis_y;
plot(Cnew_basis_x,Cnew_basis_y,'k-o')

Cnew2_x = basis*Cnew_basis_x;
Cnew2_y = basis*Cnew_basis_y;
plot(Cnew2_x,Cnew2_y,'y-*')
plot(Cnew_x(pi_index),Cnew_y(pi_index),'rx')

