%A Fast way to do re_initialization of the 
%level set. Use this method for doing such
%things instead of the, "re_initialize.m" file

function sdistance = re_distance(lset,iterations)

dt = 0.1;
[nx,ny] = size(lset);
nO=1;

sdistance = zeros(nx,ny);

lset = [lset(nO:-1:1,nO:-1:1) lset(nO:-1:1,:) lset(nO:-1:1,end:-1:end-nO+1); ...
            lset(:,nO:-1:1) lset lset(:,end:-1:end-nO+1); ...
            lset(end:-1:end-nO+1,nO:-1:1) lset(end:-1:end-nO+1,:) lset(end:-1:end-nO+1,end:-1:end-nO+1)];
    
for iter = 1:iterations
 
 sign_lset = sign(lset(2:end-1,2:end-1));
 
     Dx_m = lset(2:end-1,2:end-1) - lset(1:end-2,2:end-1);
     Dx_p = lset(3:end,2:end-1) - lset(2:end-1,2:end-1);
     Dy_m = lset(2:end-1,2:end-1)- lset(2:end-1,1:end-2);
     Dy_p = lset(2:end-1,3:end) - lset(2:end-1,2:end-1);
     grad_m = sqrt(max(Dx_m,0).^2 + min(Dx_p,0).^2 + max(Dy_m,0).^2 + min(Dy_p,0).^2);
     grad_p = sqrt(min(Dx_m,0).^2 + max(Dx_p,0).^2 + min(Dy_m,0).^2 + max(Dy_p,0).^2);
     
     neg = find(sign_lset<0);
     sdistance(neg) = -1 + grad_p(neg);
     pos = find(sign_lset>0);
     sdistance(pos) = 1 - grad_m(pos);
     
     lset(2:end-1,2:end-1) = lset(2:end-1,2:end-1) + dt * sdistance;
end
sdistance = lset(2:end-1,2:end-1);
